#  $Id: 2umlaut.awk 0.03 1995/09/18 00:00:03 tom Exp $
#
#  2umlaut.awk:  Very simple and silly `AWK' script for converting
#                  "a "o "u "s "A "O "U  character sequences found
#                  in a German text to sequences, the TeX formatter
#                  should be able to typeset as German "Umlaute".
#
#
#  Public domain.
#
#
#  This solution only works with GAWK or other modern AWK implementations...
#
#  /@chapter|@section|@subsection|@subsubsection/ {
#    gsub(/"a/,"ae");
#    gsub(/"o/,"oe");
#    gsub(/"u/,"ue");
#    gsub(/"s/,"ss");
#    gsub(/"A/,"Ae");
#    gsub(/"O/,"Oe");
#    gsub(/"U/,"Ue");
#    print
#    next;
#  }
#
#  This solution should work with every AWK implementation!
#
#
#  Write:       /@node|@chapter|@section|@subsection|@subsubsection/ {
#
#  instead of:  /@chapter|@section|@subsection|@subsubsection/ {
#
#  if you want to change the replacement characters ("a "o "u...) in the
#  gcal-de.texi file to (ae oe ue...) characters for the info-file!
#
/@chapter|@section|@subsection|@subsubsection/ {
  len = length($0)
  tmptxt = ""
  if ($0 ~ /"/)
   {
     found = 0
     for (i=1; i <= len; i++)
      {
        tmpchr = substr($0, i, 1)
        if (tmpchr == "\"")
         {
           if (found == 1)
            {
              found = 0
              tmptxt = tmptxt tmpchr tmpchr
            }
           else
             found = 1
         }
        else
         {
           if (found == 1)
            {
              found = 0
              if (tmpchr == "a")
                tmptxt = tmptxt "ae"
              else
               {
                 if (tmpchr == "o")
                   tmptxt = tmptxt "oe"
                 else
                  {
                    if (tmpchr == "u")
                      tmptxt = tmptxt "ue"
                    else
                     {
                       if (tmpchr == "s")
                         tmptxt = tmptxt "ss"
                       else
                        {
                          if (tmpchr == "A")
                            tmptxt = tmptxt "Ae"
                          else
                           {
                             if (tmpchr == "O")
                               tmptxt = tmptxt "Oe"
                             else
                              {
                                if (tmpchr == "U")
                                  tmptxt = tmptxt "Ue"
                                else
                                  tmptxt = tmptxt "\"" tmpchr
                              }
                           }
                        }
                     }
                  }
               }
            }
           else
             tmptxt = tmptxt tmpchr
         }
      }
     if (found == 1)
       print tmptxt tmpchr
     else
       print tmptxt
   }
  else
    print $0
  next
}
#
#  This solution only works with GAWK or other modern AWK implementations...
#
#  {
#    gsub(/"a/,"@\"a");
#    gsub(/"o/,"@\"o");
#    gsub(/"u/,"@\"u");
#    gsub(/"s/,"@ss ");
#    gsub(/"s /,"@ss@ ");
#    gsub(/"A/,"@\"A");
#    gsub(/"O/,"@\"O");
#    gsub(/"U/,"@\"U");
#    print
#  }
#
#  This solution should work with every AWK implementation!
#
#
#  Write:       tmptxt = tmptxt ""      <-- "a Umlaut character
#
#  instead of:  tmptxt = tmptxt "@\"a"   and so forth...
#
#  if you want to change the replacement characters ("a "o "u...) in the
#  gcal-de.texi file to real German "Umlaute" characters for the info-file!
#
{
  len = length($0)
  tmptxt = ""
  if ($0 ~ /"/)
   {
     found = 0
     for (i=1; i <= len; i++)
      {
        tmpchr = substr($0, i, 1)
        if (tmpchr == "\"")
         {
           if (found == 1)
            {
              found = 0
              tmptxt = tmptxt tmpchr tmpchr
            }
           else
             found = 1
         }
        else
         {
           if (found == 1)
            {
              found = 0
              if (tmpchr == "a")
                tmptxt = tmptxt "@\"a"
              else
               {
                 if (tmpchr == "o")
                   tmptxt = tmptxt "@\"o"
                 else
                  {
                    if (tmpchr == "u")
                      tmptxt = tmptxt "@\"u"
                    else
                     {
                       if (tmpchr == "s")
                        {
                          if (i == len)
                            tmptxt = tmptxt "@ss "
                          else
                           {
                             if (substr($0, i+1, 1) == " ")
                               tmptxt = tmptxt "@ss@ "
                             else
                               tmptxt = tmptxt "@ss "
                           }
                        }
                       else
                        {
                          if (tmpchr == "A")
                            tmptxt = tmptxt "@\"A"
                          else
                           {
                             if (tmpchr == "O")
                               tmptxt = tmptxt "@\"O"
                             else
                              {
                                if (tmpchr == "U")
                                  tmptxt = tmptxt "@\"U"
                                else
                                  tmptxt = tmptxt "\"" tmpchr
                              }
                           }
                        }
                     }
                  }
               }
            }
           else
             tmptxt = tmptxt tmpchr
         }
      }
     if (found == 1)
       print tmptxt tmpchr
     else
       print tmptxt
   }
  else
    print $0
}
