/* chrono.c : Chrono stuff, return elapsed seconds on stdout */
/* danny@limestone.kosone.com */
#include <stdio.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>

void usage(char *name) {
  fprintf(stderr,"Usage: %s [-t] || [-n]\n",name);
  fprintf(stderr,"Pauses untill return key is pressed, returns elapsed time.\n");
  fprintf(stderr,"-t: display time in tenths instead of default seconds.\n");
  fprintf(stderr,"-n: disable display.\n");
  exit(1);
}

int main(int argc, char *argv[]) {
  fd_set fds[2];
  struct timeval timeout,timenow;
  long diff,start,now,tenths=0,hours=0,minutes=0,seconds=0;
  int c,tupdate=0,output=1;
  /* For some reason, I can't get getopt() to work.  Oh well... */
  for(c=1;c<argc;c++) {
    if(argv[c][0]!='-') {
      usage(argv[0]);
    }
    if(argv[c][1]=='t') {
      tupdate=1;
    }
    else if(argv[c][1]=='n') {
      output=0;
    }
    else {
      usage(argv[0]);
    }
  }
  gettimeofday(&timenow,0);
  diff=timenow.tv_sec;  /* Substract start to get elapsed */
  start=timenow.tv_usec/100000;
  c=0;
  while(c==0) {
    FD_ZERO(fds);
    FD_SET(0,fds);  /* Prepare to select() from stdin */
    if(tupdate) {
      timeout.tv_sec=0;
      timeout.tv_usec=100000;  /* One tenth of a sec. */
    }
    else {
      timeout.tv_sec=1;        /* Or one sec. */
      timeout.tv_usec=0;
    }
    c=select(1,fds,0,0,&timeout);
    gettimeofday(&timenow,0);
    now=(timenow.tv_sec-diff)*10L+(timenow.tv_usec/100000);
    tenths=now-start;          /* Elapsed time since start in tenths */
    seconds=tenths/10;
    tenths-=seconds*10;
    minutes=seconds/60;
    seconds-=minutes*60;
    hours=minutes/60;
    minutes-=hours*60;
    if(c==0 && output!=0) {
      if(tupdate) {
        fprintf(stderr,"\r%02d:%02d:%02d.%01d  ",hours,minutes,seconds,tenths);
      }
      else {
        fprintf(stderr,"\r%02d:%02d:%02d  ",hours,minutes,seconds);
      }
    }
  }
  if(output) {
  	fprintf(stderr,"\n");
	}
  c=getchar(); /* Get rid of return key */
  printf("%02d:%02d:%02d.%01d\n",hours,minutes,seconds,tenths);  /* Total */
  exit(0);
}
