/************************************************************************
 * calc.h								*
 *									*
 * A little RPN (Reverse Polish Notation) calculator,                   *
 * rudimentary emulating a HP 28S  					*
 * 									*
 * calc is (c) David Frey, 1993, 1994 					*
 * 									*
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *									*
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *									*
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *									*
 ************************************************************************/

/* calc.h,v
 * Revision 1.0  1994/02/20  22:32:15  david
 * Initial revision
 * */

#define FALSE 0
#define TRUE  1

#define MAXLINELENGTH  80
#define STACKSIZE     128

#define NROFCOMMANDS   65

static char delimiters[] = " \t\n";

static char *Command[] =
{
"show", "peep",
"push", "pop" , "pick"    , "swap" , "over" , "roll" ,
"dup" , "dupn", "drop"    , "dropn", "depth", "clear",
"chs" , "+"   ,	"-"	  , "*"	   , "/"    , "&",
"|"   , "^"   , "inv"     , "sqrt" , "sqr"  ,
"sin" , "cos" ,	"tan"     , "asin" , "acos" , "atan" , "atan2",
"sinh", "cosh",	"tanh"	  , "asinh", "acosh", "atanh",
"ln"  , "log" ,	"ld"	  , "exp"  , "alog" , "shl"  ,
"j0"  , "j1"  ,	"jn"      , "y0"   , "y1"   , "yn"   ,
"erf" , "erfc",	"lgamma"  ,
"abs" , "ceil",	"fact"	  , "mod"  , "gcd"  ,
"hex" , "dec" ,
"pi"  , "e"   ,
"help", "?"   , "warranty", ""
};

enum COMMANDS
{
SHOW=0, PEEP  ,
PUSH  , POP   , PICK      , SWAP   , OVER   , ROLL   ,
DUP   , DUPN  , DROP      , DROPN  , DEPTH  , CLEAR  ,
CHS   , PLUS  , MINUS     , TIMES  , DIVIDE , AND    ,
OR    , POWER , INV       , SQRT   , SQR    ,
SIN   , COS   , TAN       , ASIN   , ACOS   , ATAN   , ATAN2  ,
SINH  , COSH  , TANH      , ASINH  , ACOSH  , ATANH  ,
LN    , LOG   , LD        , EXP    , ALOG   , SHL    ,
J0    , J1    , JN        , Y0     , Y1     , YN     ,
ERF   , ERFC  , LGAMMA    ,
ABS   , CEIL  , FACT      , MOD    , GCD    ,
HEX   , DEC   ,
PUSHPI, PUSHE ,
HELP1 , HELP2 , WARRANTY
};

/* static struct option const long_options[] =
{
  {"help", no_argument, 0, 'h'},
  {"help", no_argument, 0, '?'},
  {0, 0, 0, 0}
}; */
