/*
 * Attaches standard I/O to a network socket or named file (such as a tty
 *  port) and then executes the specified command.
 *
 * $Id: attach.c 1.1 Wed, 04 Jun 1997 15:38:01 -0400 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#include <other/string.h>
#include <proc/process.h>
#include <std/files.h>
#include <net/socket.h>

void main(int argc, char **argv)
{
	char	*p;
	int	fd;
	int	port;
	struct	stat	ino;

	if(argc < 3)
		fatal(EX_USAGE, "use: attach host:service command...\n"
			        "  or attach /dev/device command...\n");

	p = strchr(argv[1], ':');
	if(p)
	{
		*(p++) = 0;
		if(isdigit(*p))
			port = atoi(p);
		else
			port = getservice(p);

		if(!port)
			fatal(EX_UNAVAILABLE, "attach: %s: no such service\n", p);

		fd = getsocket(argv[1], port, SOCK_STREAM);
		if(fd == INVALID_SOCKET)
			fatal(EX_UNAVAILABLE, "attach: %s: service unavailable\n", argv[1]);
	}
	else
	{	
		if(stat(argv[1], &ino))
			fatal(EX_OSFILE, "attach: %s: cannot access\n", argv[1]);

		if(!S_ISCHR(ino.st_mode))
			fatal(EX_OSFILE, "attach: %s: not a char device\n", argv[1]);

		fd = open(argv[1], O_RDWR);
		if(fd < 0)
			fatal(EX_OSFILE, "attach: %s: cannot open\n", argv[1]);
	}
	argv += 2;
	dup2(fd, 0);
	dup2(fd, 1);
	dup2(fd, 2);
	close(fd);
	pdetach(D_KEEPALL);
	execvp(*argv, argv);
}

