/*
 * Portable re-definition of limits header file.
 * $Id: limits.h 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#ifndef	__STD_LIMITS_H__
#define	__STD_LIMITS_H__

#include <limits.h>

#ifndef	__CONFIG_H__
#include <config.h>
#endif

#ifndef	POSIX1_LIM_H_MISSING
#include <posix1_lim.h>
#else
#ifndef	UNISTD_H_MISSING
#include <unistd.h>
#endif
#include <std/posix1_lim.h>
#endif

#ifndef	NR_OPEN
#ifdef	OPEN_MAX
#define	NR_OPEN OPEN_MAX
#else
#define	NR_OPEN _POSIX_OPEN_MAX
#endif
#endif

#ifndef	NGROUPS_MAX
#define	NGROUPS_MAX _POSIX_NGROUPS_MAX
#endif

#ifndef	CHILD_MAX
#define	CHILD_MAX _POSIX_CHILD_MAX
#endif

#ifndef	ARG_MAX
#define	ARG_MAX	_POSIX_ARG_MAX
#endif

#ifndef	LINK_MAX
#define	LINK_MAX _POSIX_LINK_MAX
#endif

#ifndef	MAX_CANON
#define	MAX_CANON _POSIX_MAX_CANON
#endif

#ifndef	MAX_INPUT
#define	MAX_INPUT _POSIX_MAX_INPUT
#endif

#ifndef	NAME_MAX
#define	NAME_MAX _POSIX_NAME_MAX
#endif

#ifndef	PATH_MAX
#define	PATH_MAX _POSIX_PATH_MAX
#endif

#ifndef	PIPE_BUF
#define	PIPE_BUF _POSIX_PIPE_BUF
#endif

#ifndef	SSIZE_MAX
#define	SSIZE_MAX INT_MAX
#endif

#ifndef STREAM_MAX
#define STREAM_MAX OPEN_MAX
#endif

#ifndef	TZONE_MAX
#define	TZONE_MAX _POSIX_TZONE_MAX
#endif

#ifdef	MSDOS
#if !defined(GNU) && !defined(__386__) 
#if defined(__BORLANDC__) && (defined(__SMALL__) || defined(__MEDIUM__))
#define	MEM_SEGMENT_MAX	16
#endif
#if defined(M_I86SM) || defined(M_I86MM))
#define	MEM_SEGMENT_MAX	16
#endif
#endif
#endif

#ifndef	MEM_SEGMENT_MAX
#define	MEM_SEGMENT_MAX	32
#endif

#endif
