/*
 * Portable string trimming routines.
 * $Id: strtrim.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#include <other/string.h>

char	*strtrim(char *str, const char *trim)
{
	return strltrim(strrtrim(str, trim), trim);
}

char	*strrtrim(char *str, const char *trim)
{
	char	*end;
	
	if(!str)
		return NULL;
		
	end = str + strlen(str);

	while(end-- > str)
	{
		if(!strchr(trim, *end))
			return str;
		*end = 0;
	}
	return str;
}

char	*strltrim(char *str, const char *trim)
{
	if(!str)
		return NULL;
		
	while(*str)
	{
		if(!strchr(trim, *str))
			return str;
		++str;
	}
	return str;
}
