/*
 * Memory pool string copy.
 * $Id: strreq.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#include <other/memory.h>

char	*strreq(MEMPOOL *mem, const char *str)
{
	char	*newstr;

	if(!str)
		return NULL;

	newstr = memreq(mem, strlen(str) + 1);
	if(!newstr)
		return NULL;

	strcpy(newstr, str);
	return newstr;
}

char	*strlreq(MEMPOOL *mem, const char *str)
{
	char	*newstr;

	if(!str)
		return NULL;

	newstr = memlreq(mem, strlen(str) + 1);
	if(!newstr)
		return NULL;

	strcpy(newstr, str);
	return newstr;
}

