/* 
 * Often used to evaluate similarity of soundex codes.
 * $Id: strdiff.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#include <other/string.h>
#include <std/math.h>

int     strdiff(const char *s1, const char *s2)
{
        int     l1 = len(s1);
        int     l2 = len(s2);
        int     l = min(l1, l2);
        int     dif = abs(l1 - l2);

        while(l--)
        {
                if(*(s1++) != *(s2++))
                        ++dif;
        }
        return dif;
}
