/* 
 * String copying defined for supporting over-lapping strings 'insertion'.
 * $Id: strcopy.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#include <other/string.h>

static  char *revcopy(char *to, const char *from, size_t count)
{
        while(count--)
                *(to--) = *(from--);

        *to = *from;
        return to;
};

char *strcopy(char *to, const char *from)
{
        char *s1 = to;
        int     l = from - to;
        int     l2 = len(from);

        if(!to || !from)
                return NULL;

        if(l > 0 && l <= l2)
                return revcopy(to + l2, from + l2, l2);

        ++l2;
        while(l2--)
                *(to++) = *(from++);

        return s1;
};

char *strncopy(char *to, const char *from, int l2)
{
	char *s1 = to;
        int l = from - to;
        if(len(from) < l2)
                return strcopy(to, from);

        if(!to || !from)
                return NULL;

        if(l > 0 && l <= l2)
        {
                to[l2] = 0;
                --l2;
                return revcopy(to + l2, from + l2, l2);
        }

        while(l2--)
                *(to++) = *(from++);

        *to = 0;
        return s1;
};

