/*
 * Hex digit conversion functions.
 * $Id: hex.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#include <other/strcvt.h>

char	hex(int digit)
{
        if(digit < 10)
                return '0' + digit;
        else
                return '7' + digit;
};

char *hexbyte(uchar v)
{
        static  char    h[3];

        h[0] = hex(v / 16);
        h[1] = hex(v % 16);
        h[2] = 0;
        return h;
};

char *hexshort(ushort v)
{
        static  char    h[5];

        strcpy(h, hexbyte((uchar)(v / 256)));
        strcpy(h + 2, hexbyte((uchar)(v % 256)));
        return h;
};

char *hexlong(ulong v)
{
        static  char    h[9];

        strcpy(h, hexshort((ushort)(v / 65536)));
        strcpy(h + 4, hexshort((ushort)(v % 65536)));
        return h;
};
