/*
 * Routines to access directory of section names in a config file.
 * $Id: confdir.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and use see product license.
 *
 * Abstract:
 *	These routines may be used to scan the 'directory' of [] section
 *	names within a config file, much like the MS-DOS find_first() and 
 *	find_next() directory routines.
 * 
 * Functions:
 *	this_config() - internal routine to return section name.
 *	first_config() - goto first named [] section within the config file.
 *	next_config() - skip to the next named [] section.
 */

#include <other/config.h>
#include <other/string.h>
#include <other/env.h>

#ifndef	LBUF
#define	LBUF	1024
#endif

/*
 * Internal program to support parsing of found section name.
 */

static	char	*this_config(CONFIG *cfg)
{
	char *p;
	
	if(feof(cfg->cfg_fp))
		return NULL;
	
	if(cfg->cfg_lbuf[0] != '[')
		return NULL;
		
	cfg->cfg_flag = TRUE;
	p = strtok(cfg->cfg_lbuf, "[]\n\r");
	return p;
}

/*
 * Automatically seek the very first [] section within a config file.
 *
 * Paramaters:
 *	cfg - config object pointer.
 *
 * Returns:
 * 	Name string of first [] name in config file.
 *
 * Exceptions:
 *	If no [] section in config file, NULL cfg pointer, or file
 *	error, returns NULL.
 */

char	*first_config(CONFIG *cfg)
{
	if(!cfg)
		return NULL;
	
	fseek(cfg->cfg_fp, 0l, SEEK_SET);
	return next_config(cfg);
}

/*
 * Skip to the next named [] section within a config file.
 *
 * Paramaters:
 *	cfg - config object pointer.
 *
 * Returns:
 *	Name string of next named [] section in config file.
 *
 * Exceptions:
 *	Returns NULL if cfg invalid or end of file reached.
 *
 */

char	*next_config(CONFIG *cfg)
{
	if(!cfg)
		return NULL;

	if(feof(cfg->cfg_fp))
		return NULL;
		
	for(;;)
	{
		fgets(cfg->cfg_lbuf, LBUF - 1, cfg->cfg_fp);
		if(feof(cfg->cfg_fp))
			return NULL;
			
		if(cfg->cfg_lbuf[0] == '[')
			return this_config(cfg);
	}
}


	

	
	
