/*
 * Count character occurances in string.
 * $Id: ccount.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and use see product license.
 *
 * Functions:
 * 	ccount() - count characters in string.
 */

#include <other/string.h>

/*
 * Count character occurances in ASCII string.
 *
 * Abstract:
 *	A list of possible characters to look for is passed to ccount,
 *	along with the null terminated ASCII string to look for those
 *	characters within.
 *
 * Parameters:
 *	str - string to examine and count occurances in.
 *	list - list (null terminated) of characters to search for.
 *
 * Exceptions:
 *	Either a NULL list or string is considered to hold no found
 *	characters (returns 0).
 */

int	ccount(const char *str, const char *list)
{
	int	count = 0;

	if(!str || !list)
		return 0;
	
	while(NULL != (str = strpbrk(str, list)))
	{
		++count;
		++str;
	}
	return count;
}

	
