/*
 * Stream oriented TCP session routines.
 * $Id: stream.h 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#ifndef	__NET_STREAM_H__
#define	__NET_STREAM_H__

#ifndef	__NET_SOCKET_H__
#include <net/socket.h>
#endif

#define	tcppeer(fp)	peername(fileno(fp))
#define	tcphome(fp)	homename(fileno(fp))

typedef	FILE	*STREAM;

#ifdef	__cplusplus
extern "C" {
#endif

#ifdef	__NAMESPACE
#define	opentcp		__NAMESPACE(opentcp)
#define	accepttcp	__NAMESPACE(accepttcp)
#define	gettcp		__NAMESPACE(gettcp)
#define	puttcp		__NAMESPACE(puttcp)
#define	closetcp	__NAMESPACE(closetcp)
#define	buftcp		__NAMESPACE(buftcp)
#endif

STREAM	opentcp(const char *hostname, int port);
STREAM	accepttcp(SOCKET so); 
char	*gettcp(char *buf, size_t count, STREAM fp);
int	puttcp(char *str, STREAM fp);
void	closetcp(STREAM fp);
int	buftcp(STREAM fp, int size);

#ifdef	__cplusplus
}
#endif

#endif

