/*
 * Portable include for access of socket services.
 * $Id: socket.h 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#ifndef	__NET_SOCKET_H__
#define	__NET_SOCKET_H__

#ifndef	__STD_FILES_H__
#include <std/files.h>
#endif

#ifndef	__STD_TYPES_H__
#include <std/types.h>
#endif

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

typedef	int	SOCKET;
#define	INVALID_SOCKET	-1

#ifdef	__cplusplus
extern "C" {
#endif

#ifdef	__NAMESPACE
#define	init_sockets	__NAMESPACE(init_sockets)
#define	gethost		__NAMESPACE(gethost)
#define	getservice	__NAMESPACE(getservice)
#define	peername	__NAMESPACE(peername)
#define	peeraddr	__NAMESPACE(peeraddr)
#define	homename	__NAMESPACE(homename)
#define	homeaddr	__NAMESPACE(homeaddr)
#define	endsocket	__NAMESPACE(endsocket)
#define	udpsocket	__NAMESPACE(udpsocket)
#define	tcpsocket	__NAMESPACE(tcpsocket)
#define	getsocket	__NAMESPACE(getsocket)
#endif

bool	init_sockets(void);
struct	hostent	*gethost(const char *host);
struct	in_addr *getnetaddr(const char *addr);
int	getservice(const char *service);
char	*peername(SOCKET so);
char	*peeraddr(SOCKET so);
char	*homename(SOCKET so);
char	*homeaddr(SOCKET so);
void	endsocket(SOCKET so);
SOCKET	udpsocket(char *mask, int port);
SOCKET	tcpsocket(char *mask, int port, int backlog);
SOCKET	getsocket(const char *host, int port, int socktype);
#ifdef	__cplusplus
}
#endif

#endif
