/*GPL*START*
 * 
 * Copyright (C) 1998 by Johannes Overmann <overmann@iname.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * *GPL*END*/  

#ifndef _tgenericclassdump_h_
#define _tgenericclassdump_h_
#include "atypes.h"
#include <stdio.h>

// 1997
// Aug 31 13:00: void * added
// 1998
// Jan 04 03:00: LF() removed

inline void dump(short s) {printf("%hd", s);}
inline void dump(ushort us) {printf("%hu", us);}
inline void dump(int i) {printf("%d", i);}
inline void dump(uint u) {printf("%u", u);}
inline void dump(long l) {printf("%ld", l);}
inline void dump(ulong ul) {printf("%lu", ul);}

inline void dump(bool b) {if(b) printf("true"); else printf("false");}

inline void dump(float f) {printf("%f", f);}
inline void dump(double d) {printf("%f", d);}
inline void dump(long double ld) {printf("%Lf", ld);}

inline void dump(const char *s) {printf("\"%s\"", s);}
inline void dump(const void *s) {printf("->%p", s);}




inline void dump(FILE *f, short s) {fprintf(f, "%hd", s);}
inline void dump(FILE *f, ushort us) {fprintf(f, "%hu", us);}
inline void dump(FILE *f, int i) {fprintf(f, "%d", i);}
inline void dump(FILE *f, uint u) {fprintf(f, "%u", u);}
inline void dump(FILE *f, long l) {fprintf(f, "%ld", l);}
inline void dump(FILE *f, ulong ul) {fprintf(f, "%lu", ul);}

inline void dump(FILE *f, bool b) {if(b) fprintf(f, "true"); else fprintf(f, "false");}

inline void dump(FILE *f, float fl) {fprintf(f, "%f", fl);}
inline void dump(FILE *f, double d) {fprintf(f, "%f", d);}
inline void dump(FILE *f, long double ld) {fprintf(f, "%Lf", ld);}

inline void dump(FILE *f, const char *s) {fprintf(f, "\"%s\"", s);}
inline void dump(FILE *f, const void *s) {fprintf(f, "->%p", s);}


#endif










