/*GPL*START*
 * 
 * Copyright (C) 1998 by Johannes Overmann <overmann@iname.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * *GPL*END*/  

#ifndef _tappconfig_h_
#define _tappconfig_h_

#include "tobject.h"
#include "string.h"
#include "tassocarray.h"




enum TACO_TYPE {NONE, STRING, INT, DOUBLE, BOOL, SWITCH};
enum TACO_SET_IN {NEVER, DEFAULT, COMMAND_LINE, RC_FILE, ENVIRONMENT, APPLICATION};
enum TACO_STRING_MODE {OVERRIDE, APPEND, ONCE};

// global application pointer
class TAppConfig;
extern TAppConfig *tApp;

// should be a private subclass of TAppConfig
class TAppConfigItem: public TObject {
 public:
   // cons
   TAppConfigItem();
   TAppConfigItem(const char *confitem, const char *context, bool privat);
   
   // type info
   CLASSNAME("TAppConfigItem");
   FULLCLASSNAME(TObject);

   // interface
   void printItemToFile(FILE *f) const; // print default
   void printCurItemToFile(FILE *f, bool simple) const; // print current
   void printValue(const string& env, const string& rcfile) const;
   void printHelp(int maxoptlen, bool globalonlycl) const;
   int getOptLen() const;
   string getTypeStr() const;
   void setValue(const string& par, TACO_SET_IN setin, 
		 bool verbose=false, const string& env="", 
		 const string& rcfile="",
		 const string& context="command line");
   
   // set from application methods:
   
   // returns true if value is valid, else false
   // sets value from string according to any type (switch == bool here)
   bool setValueFromAppFromStr(const string& parameter);
   void setValueFromApp(const string& str);
   // returns true if value is valid, else false
   bool setValueFromApp(double d);
   // returns true if value is valid, else false
   bool setValueFromApp(int i);
   void setValueFromApp(bool b);
   



 private: 
   // private methods
   void setComp(const TArray<string>& a, bool privat);
   void validate(const char *context);
   void privateInit();
   string getParamStr() const;
   string getWasSetStr(const string& env, const string& rcfile) const;
   string getWasSetStr(TACO_SET_IN setin, const string& env, const string& rcfile) const;
   string getFlagsStr(const string& optprefix, bool globalonlycl) const;
   

 public:   
   // data
   bool must_have;
   bool should_have;
   bool only_cl;
   bool configopt;
   bool only_app;
   bool save;
   
   TACO_TYPE type;
   TACO_SET_IN set_in;
   TACO_STRING_MODE string_mode;
   string string_sep;
   double double_value, double_upper, double_lower, double_default;
   int int_value, int_upper, int_lower, int_default;
   bool bool_value, bool_default;
   
   // temp flag
   bool printed;

   string name;
   string context;
   string help;
   string headline;
   string char_name;
   string par;
   TArray<string> alias;
   string type_str;
   string upper, lower, def;
   string string_value, string_default;
};


// this is the main class of this h file
class TAppConfig: public TObject {
 public:
   // ctor & dtor
   TAppConfig(const char *conflist[], const char *listname,
	      int argc, char *av[],
	      const char *envstrname,
	      const char *rcname,
	      const string& version);
   ~TAppConfig();
   
   // type info
   CLASSNAME("TAppConfig");
   FULLCLASSNAME(TObject);
   
   // main interface
   void printHelp() const;
   void printValues() const;
   bool save(string& rc_name_out); // save items with item.save==true
   
   // typed options:
   const string& getString(const string& par) const;
   double getDouble(const string& par) const;
   int getInt(const string& par) const;
   bool getBool(const string& par) const;        // bool + switch
   bool getSwitch(const string& par) const;      // bool + switch
   bool operator() (const string& par) const; // bool + switch
   
   // untyped parameters:
   string param(int i) const {return _params(i);}
   int numParam() const {return _params.num();}
   const TArray<string>& params() const {return _params;}
   
   // set values: 
   // returns true if value is valid, else false
   // sets value from string according to any type (switch == bool here)
   bool setValueFromStr(const string &n, const string& str);
   void setValue(const string &n, const string& str);
   bool setValue(const string &n, double d);
   bool setValue(const string &n, int i);
   void setValue(const string &n, bool b);

   // return the upper and lower bounds and defaults for the type
   int intUpper(const string &n) const;
   int intLower(const string &n) const;
   int intDefault(const string &n) const;
   double doubleUpper(const string &n) const;
   double doubleLower(const string &n) const;
   double doubleDefault(const string &n) const;
   string stringDefault(const string &n) const;
   bool   boolDefault(const string &n) const;
   

   
 private:
   // readonly public data
   TArray<string> _params;
   
   // private data
   TAssocArray<string,int> name;  // get index of long name
   int char2index[256];           // get index of short name
   TArray<TAppConfigItem> opt;    // all options in the order of conflist
   TAssocArray<string,int> alias; // aliases for options
   string envname;    // name of env var
   string rc_name;    // name of loaded rc file
   string rc_str;     // namestr of rc file
   bool verbose_conf; // verbose configuration: warnings and values
   bool onlycl;       // true== dont use rcfile and envvar, only command line
   bool stopatdd;     // stop option scanning after --
   string usage;      // usage string: printed before help
   string trailer;    // trailer string: printed after help
   string commonhead; // headline for common options
   
   int getMaxOptLen() const;
   void doMetaChar(const string& str, const string& context);
   void setComp(const TArray<string>& a, const string& context);
   void addConfigItems(const char **list, const char *listname, bool privat);
   void doCommandLine(int ac, char *av[], const string& version);
   void doEnvironVar(const char *envvar);
   void doRCFile(const string& rcfile, const string& clrcfile);
   void setFromStr(const string& str, const string& context, TACO_SET_IN setin);
   string getName(const string& str, const string& context, const string& optprefix="") const;
   void createRCFile(const string& fname, const string& rcname) const;
};


#endif
