/*GPL*START*
 * 
 * Copyright (C) 1998 by Johannes Overmann <overmann@iname.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * *GPL*END*/  

#include <ctype.h>
#include "str2value.h"
#include <stdlib.h>

// 1997
// Aug 8 02:00 Str2Bool fixed

bool str2getBool(const char *str, bool& err) {
   char buf[7];
   int i;
   for(i=0; i<6; i++) {
      buf[i] = tolower(str[i]);
      if((buf[i]==0) || isspace(buf[i])) break; 
   }
   buf[i]=0;   
   err = false;
   switch(i) {
    case 1:
      if((buf[0]=='0')||(buf[0]=='f')) return false;
      if((buf[0]=='1')||(buf[0]=='t')) return true;
      break;
    case 2:
      if(strcmp(buf,"on")==0) return true;
      if(strcmp(buf,"no")==0) return false;
      break;
    case 3:
      if(strcmp(buf,"off")==0) return false;
      if(strcmp(buf,"yes")==0) return true;
      break;
    case 4:
      if(strcmp(buf,"true")==0) return true;
      break;
    case 5:
      if(strcmp(buf,"false")==0) return false;
      break;
   }   
   err = true;
   return false;
}


int str2getInt(const char *str, bool& err) {
   char *p;
   int r = strtol(str, &p, 0);
   if((isspace(*p) || (*p==0)) && (*str!=0)) err = false;
   else err = true;
   return r;     
}


double str2Double(const char *str, bool& err) {
   char *p;
   double r = strtod(str, &p);
   if((isspace(*p) || (*p==0)) && (*str!=0)) err = false;
   else err = true;
   return r;     
}

