/*GPL*START*
 * 
 * Copyright (C) 1998 by Johannes Overmann <overmann@iname.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * *GPL*END*/  

#ifndef _memoryfence_h_
#define _memoryfence_h_

extern bool memoryfence_disable_check;
extern char *current_function;
extern char *current_file;
extern int current_line;

#define CHECKPOINT {current_function=__PRETTY_FUNCTION__;current_file=__FILE__;current_line=__LINE__;}
#define PRINTLASTCHECKPOINT {printf("%s:%d: '%s'\n", current_file, current_line, current_function);}

#define C_P CHECKPOINT
#define P_L PRINTLASTCHECKPOINT

void check_fences(const void *mem, const char *inst);

#endif

