/*GPL*START*
 * 
 * Copyright (C) 1998 by Johannes Overmann <overmann@iname.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * *GPL*END*/  


#include "atypes.h"
#include "memoryfence.h"
#include "hexdump.h"
/* for INT_MAX */
#include <limits.h>
/* for malloc, free: */
#include <stdlib.h>
/* for fprintf: */
#include <stdio.h>
/* for memset: */
#include <string.h>
/* for signal: */
#include <signal.h>



// memoryfence 
// Jun 04 1997: old version canceled, this is full new version V0.1
//   SIMPLE fence implemented and tested with 'qdiff', seems to work fine,
//   and seems to be very sufficient, don't know about 'ADVANCED fence'

// Sep 16 1998: fix egcs warning, test: ok

// 
//    BEGIN of memoryfence CONFIGURATION   
// 





// SIMPLE fence
// number of new/deleted blocks is checked and reported
// total and average size is reported
// size of erroneous large request is reported 
//#define SIMPLE

// option: do not free deleted blocks
#define SIMPLE_NOFREE
// option: check for out of bound write (fence with byte value SIMPLE_FENCE)
#define SIMPLE_FENCE 'F'
#define SIMPLE_FENCE_SIZE 16
// option: fill new memory with byte value SIMPLE_SETMEM_NEW
#define SIMPLE_SETMEM_NEW 0x77
// option: fill deleted memory with byte value SIMPLE_SETMEM_DELETE
//         perhaps specify also SIMPLE_NOFREE with this
#define SIMPLE_SETMEM_DELETE 0x55
// option: bias for nr of blocks
#define SIMPLE_NUMBLOCK_BIAS 0
// option: record size of blocks
#define SIMPLE_SIZE_HIST
#define MAX_SIZE_HIST 65000

// ADVANCED fence
// not yet implemented
//#define ADVANCED


// 
//    _END_ of memoryfence CONFIGURATION   
// 




// hook for external configuration
#ifdef MEMORYFENCE
#ifndef SIMPLE
#define SIMPLE
#endif
#endif



// global data



bool memoryfence_disable_check = false;
char *current_function="";
char *current_file="";
int current_line = -1;
int current_pos = 0;




#ifdef SIMPLE
#ifdef _SGI_IRIX_
static const char *red = "\033[31m";
static const char *grn = "\033[32m";
static const char *nor = "\033[00m";
#else
static const char *red = "\033[31;01m";
static const char *grn = "\033[32;01m";
static const char *nor = "\033[m";
#endif
#endif

// ------------------- SIMPLE ------------------------------------------------
#ifdef SIMPLE
 
typedef void (*sighandler_t)(int);

void sighand_segv(int sig) {
   printf("SIGSEGV (%d) catched!\n", sig);
   if(current_line==-1) {
      printf("sorry, no checkpoint reached, yet\n");
   } else {
      PRINTLASTCHECKPOINT;
   }
   exit(0);
}

class MF {
 public:
   MF():total_size(0), total_blocks(0),
   current_blocks(SIMPLE_NUMBLOCK_BIAS), 
   minimal_size(INT_MAX),
   maximal_size(0), maximal_blocks(0), touched_fences(0), size_hist_more(0) {
//      printf("init: currect_blocks=%d\n", current_blocks);
      signal(SIGSEGV, sighand_segv);
      
      // init size hist
      for(int i=0; i < MAX_SIZE_HIST; i++) size_hist[i] = 0;
   }

   ~MF() {
      if(memoryfence_disable_check) return;
      printf("\n--- SIMPLE MemoryFence report ----------------------------\n");
      printf("total number of blocks allocated:%10d\n", total_blocks);
      printf("total memory           allocated:%10d bytes (%4dMB)\n", total_size, total_size>>20);
      printf("average blocksize               :%10.1f bytes\n", ((double)total_size)/((double)total_blocks));
      printf("minimal/maximal blocksize       :%10d/%d bytes\n", minimal_size, maximal_size);
      printf("maximal number of blocks alloctd:%10d\n", maximal_blocks);
      if(current_blocks || touched_fences)
	printf("%serror:%s\n", red, nor);
      if(current_blocks) {
	 printf("%snumber of undeleted blocks%s      :%10d\n", red, nor, current_blocks);
      } else {
	 printf("%sno undeleted blocks found%s\n", grn, nor);
      }
# ifdef SIMPLE_FENCE
      if(touched_fences) {
	 printf("%snumber of touched fences%s        :%10d\n", red, nor, touched_fences);
      } else {
	 printf("%sno fence touched%s\n", grn, nor);
      }
# endif
# ifdef SIMPLE_SIZE_HIST
      for(int i=0; i < MAX_SIZE_HIST; i++) { 
	 if(size_hist[i]) {
	    printf("number of blocks with size%6d:%10d\n", i, size_hist[i]);
	 }
      }
      printf("number of blocks with size>=%4d:%10d\n", MAX_SIZE_HIST, size_hist_more);
# endif
      printf("----------------------------------------------------------\n");
   }
   
   void New(int size) {
      total_size += size; 
      total_blocks++; 
      current_blocks++;
      if(size < minimal_size) minimal_size = size;
      if(size > maximal_size) maximal_size = size;
      if(current_blocks > maximal_blocks) maximal_blocks = current_blocks;
      if(size < MAX_SIZE_HIST) size_hist[size]++;
      else size_hist_more++;
   }
   
   void Delete() {
      current_blocks--;
//      if(current_blocks<0) printf("currect_blocks=%d\n", current_blocks);
   }

   void Touch() {touched_fences++;}

 private:  // private data
   int total_size;
   int total_blocks;
   int current_blocks;
   int minimal_size;
   int maximal_size;
   int maximal_blocks;
   int touched_fences;
   int size_hist[MAX_SIZE_HIST];
   int size_hist_more;
} mf;

static void last_check() {
   if(current_line==-1) {
      printf("no checkpoint available\n");      
   } else {
      printf("last checkpint was at:\n");
      PRINTLASTCHECKPOINT;
   }
}
 
 
void * operator new(size_t size) {
//   printf("in operator new\n");
   void *mem = malloc(size
# ifdef SIMPLE_FENCE
		      + sizeof(int) + 2 * SIMPLE_FENCE_SIZE
# endif
		      );
   if(mem==0) {
      printf("insufficient virtual memory!\n");
      printf("(requested size of erroneous block was %d bytes = %dMB)\n",
	      (int) size, (int) (size>>20));
      last_check();
      exit(0);
   }
   mf.New(size);

# ifdef SIMPLE_FENCE
   *((int *)mem) = size;
   uchar *cmem = (uchar *)mem;
   cmem += sizeof(int);
   for(int i=0; i<SIMPLE_FENCE_SIZE; i++, cmem++)
     *cmem = SIMPLE_FENCE;
   mem = cmem;
   cmem += size;
   for(int i=0; i<SIMPLE_FENCE_SIZE; i++, cmem++)
     *cmem = SIMPLE_FENCE;
# endif

# ifdef SIMPLE_SETMEM_NEW
   memset(mem, SIMPLE_SETMEM_NEW, size);
# endif
     
   return mem; 
}


void operator delete(void *mem) {
//   printf("in operator delete\n");
   mf.Delete();

# ifdef SIMPLE_FENCE
   uchar *cmem = (uchar *)mem;
   cmem -= sizeof(int) + SIMPLE_FENCE_SIZE;
   mem = cmem;
   int size = *((int *)cmem);
   cmem += sizeof(int);
   bool touched = false;
   for(int i=0; i<SIMPLE_FENCE_SIZE; i++, cmem++)
     if(*cmem != SIMPLE_FENCE) touched = true;
   cmem += size;
   for(int i=0; i<SIMPLE_FENCE_SIZE; i++, cmem++)
     if(*cmem != SIMPLE_FENCE) touched = true;
   if(touched) {
      mf.Touch();
      printf("SIMPLE_FENCE: %sfence touched!%s (size=%d, fence size=%d, byte value=0x%02X)\n",
	      red, nor, size, SIMPLE_FENCE_SIZE, SIMPLE_FENCE);
      last_check();
      printf("dump of pre fence:\n");
      hexDump(stdout, cmem-size-2*SIMPLE_FENCE_SIZE, SIMPLE_FENCE_SIZE);
      printf("dump of mem:\n");
      hexDump(stdout, cmem-SIMPLE_FENCE_SIZE-size, size);      
      printf("dump of post fence:\n");
      hexDump(stdout, cmem-SIMPLE_FENCE_SIZE, SIMPLE_FENCE_SIZE);      
   }
# endif

# ifdef SIMPLE_SETMEM_DELETE
   memset(mem, SIMPLE_SETMEM_DELETE, size 
#  ifdef SIMPLE_FENCE
	  + sizeof(int) + 2 * SIMPLE_FENCE_SIZE
#  endif
	  );
# endif

# ifndef SIMPLE_NOFREE
   free(mem);
# endif
}


void check_fences(const void *mem, const char *inst) {
# ifdef SIMPLE_FENCE
   const uchar *cmem = (const uchar *)mem;
   cmem -= sizeof(int) + SIMPLE_FENCE_SIZE;
   int size = *((int *)cmem);
   cmem += sizeof(int);
   bool touched = false;
   for(int i=0; i<SIMPLE_FENCE_SIZE; i++, cmem++)
     if(*cmem != SIMPLE_FENCE) touched = true;
   cmem += size;
   for(int i=0; i<SIMPLE_FENCE_SIZE; i++, cmem++)
     if(*cmem != SIMPLE_FENCE) touched = true;
   if(touched) {
      printf("check_fences(%s): %sfence touched!%s (size=%d, fence size=%d, byte value=0x%02X)\n", inst,
	      red, nor, size, SIMPLE_FENCE_SIZE, SIMPLE_FENCE);
      printf("dump of pre fence:\n");
      hexDump(stdout, cmem-size-2*SIMPLE_FENCE_SIZE, SIMPLE_FENCE_SIZE);
      printf("dump of mem:\n");
      hexDump(stdout, cmem-SIMPLE_FENCE_SIZE-size, size);      
      printf("dump of post fence:\n");
      hexDump(stdout, cmem-SIMPLE_FENCE_SIZE, SIMPLE_FENCE_SIZE);      
   }
#else
   printf("check_fences() not available without SIMPLE_FENCE!\n");
# endif
}

 
#endif /* SIMPLE */



 // ------------------- ADVANCED ---------------------------------------------
#ifdef ADVANCED


#endif /* ADVANCED */













