/*GPL*START*
 * 
 * Copyright (C) 1998 by Johannes Overmann <overmann@iname.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * *GPL*END*/  


#include "hexdump.h"
#include <string.h>

static char ValidateChar(char c) {
   if((c>=' ')&&(c<127)) return c;
   else return '.';
}

void hexDump(const unsigned char *m, int l) {
   hexDump(stdout, m, l);
}

void shortHexDump(const unsigned char *m, int l) {
   shortHexDump(stdout, m, l);
}

void hexDump(FILE *f, const unsigned char *m, int l) {
   int s,i;
   char buf[100];
   char *p;
   
   buf[0]=0;
   for(s=0; s<l; s+=16) {
      fprintf(f, "%08X: ", s);
      for(p=buf, i=0; i<16; i++) {
	 if(s+i<l) {
	    fprintf(f, "%02X", m[s+i]);
	    *(p++) = ValidateChar(m[s+i]);
	 } else {
	    fprintf(f, "  ");
	    *(p++) = ' ';
	 }
	 if(i==7 && (s+i < l-1)) {
	    fprintf(f, "-");
	    *(p++) = ' ';	 
	 } else {
	    fprintf(f, " ");
	 }
      }
      *p=0;
      fprintf(f, "| %s\n", buf);
   }
}

void shortHexDump(FILE *outfile, const unsigned char *m, int l) {
   int i;
   char buf[100];
   char *p;
   
   for(p=buf, i=0; i<16; i++) {
      if(i<l) {
	 fprintf(outfile, "%02X", m[i]);
	 *(p++) = ValidateChar(m[i]);
      } else {
	 fprintf(outfile, "  ");
	 *(p++) = ' ';
      }
      if(i==7 && (i < l-1)) {
	 fprintf(outfile, "-");
      }
      else fprintf(outfile, " ");
   }
   buf[16]=0;
   fprintf(outfile, "%s%8d\n", buf, l);
}

