/* TODO: recursive directories, ... */

#include <sys/types.h>
#include <dirent.h>
#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#define VERSION "0.1"

/* ============================================================================================= */

struct  Nodes
{
        char                *name;
        off_t                length;
        int                  holdcnt;
        struct Nodes        *samenext;
        struct Nodes        *next;
};

/* ============================================================================================= */

char * NewStrDup ( const char *s )
{
char *ns;

  ns = ( char * )malloc ( strlen ( s ) + 1 );

  if ( ns != NULL )
    strcpy ( ns, s );

  return ns;
}

/* ============================================================================================= */

int
yesno ()
{
  char buf[128];
  int len = 0;
  int c;

  while ((c = getchar ()) != EOF && c != '\n')
    if ((len > 0 && len < 127) || (len == 0 && !isspace (c)))
      buf[len++] = c;
  buf[len] = '\0';

  if ( ( len == 1 ) && ( ( buf[0] == 'Y' ) ||
                         ( buf[0] == 'y' ) ||
                         ( buf[0] == 'J' ) ||
                         ( buf[0] == 'j' ) ) )
  {
    return 0;
  }
  return 1;
}

/* ============================================================================================= */

struct Nodes *InitList ( void )
{
  return NULL;
}

/* ============================================================================================= */

struct Nodes * PutList ( struct Nodes *nodeptr,
                         char *newname,
                         off_t newlength,
                         int newholdcnt )
{
struct Nodes     *posptr,
                 *memptr;
char             *name;

  posptr = nodeptr;

  name = NewStrDup ( newname );

  if ( name == NULL )
  {
    /* Error */
    fprintf ( stderr, "error: malloc ...\n" );
    exit( 1 );
  }

  memptr = ( struct Nodes * )malloc ( sizeof ( struct Nodes ) );

  if ( memptr == NULL )
  {
    /* No Memory */
    fprintf ( stderr, "error: malloc ...\n" );
    free ( name );
    exit( 1 );
  }
  else
  {
    if ( posptr == NULL )
    {
      /* List Empty */
      memptr->name        = name;
      memptr->length      = newlength;
      memptr->holdcnt     = newholdcnt;
      memptr->next        = NULL;
      memptr->samenext    = NULL;

      return memptr;
    }
    else
    {
      while ( 1 )
      {
        if ( posptr->length == newlength )
        {
          while ( posptr->samenext != NULL )
          {
            posptr = posptr->samenext;
          }
          /* Double size */
          memptr->name        = name;
          memptr->length      = newlength;
          memptr->holdcnt     = newholdcnt;
          memptr->next        = NULL;
          memptr->samenext    = NULL;

          posptr->samenext    = memptr;
          return nodeptr;
        }

        if ( posptr->length > newlength )
        {
          memptr->name        = posptr->name;
          memptr->length      = posptr->length;
          memptr->holdcnt     = posptr->holdcnt;
          memptr->next        = posptr->next;
          memptr->samenext    = posptr->samenext;

          posptr->name        = name;
          posptr->length      = newlength;
          posptr->holdcnt     = newholdcnt;
          posptr->next        = memptr;
          posptr->samenext    = NULL;

          return nodeptr;
        }

        if ( posptr->next == NULL )
        {
          memptr->name        = name;
          memptr->length      = newlength;
          memptr->holdcnt     = newholdcnt;
          memptr->next        = NULL;
          memptr->samenext    = NULL;

          posptr->next        = memptr;
          return nodeptr;
        }
        posptr = posptr->next;
      }
    }
  }
  return nodeptr;
}

/* ============================================================================================= */

void
DelList ( struct Nodes *nodeptr )
{
struct Nodes       *posptr,
                   *posptr2;

  while ( nodeptr != NULL )
  {
    posptr = nodeptr;

    while ( posptr->samenext != NULL )
    {
      posptr2 = posptr->samenext;
      free ( posptr2->name );
      posptr = posptr->samenext;
      free ( posptr2 );
    }
    posptr = nodeptr;
    /* Free Memory Of Allocated Strings */
    free ( nodeptr->name );
    nodeptr = nodeptr->next;
    free ( posptr );
  }
}

/* ============================================================================================= */

/* 0 = files are same, 1 = files are different, -1 = error */

int
DiffFiles ( const char *file1, const char *file2, off_t size )
{
  FILE              *filehd1,
                    *filehd2;
  void              *buffer1,
                    *buffer2;
  unsigned long int  readlen1,
                     readlen2;

  /* Get buffer mem for files */
  buffer1 = ( void *)malloc ( 16384 );
  buffer2 = ( void *)malloc ( 16384 );

  if ( buffer1 == NULL )
  {
    return -1;
  }

  if ( buffer2 == NULL )
  {
    free ( buffer1 );
    return -1;
  }

  /* Open the files to check */
  filehd1 = fopen ( file1, "rb" );
  filehd2 = fopen ( file2, "rb" );

  if ( filehd1 == NULL )
  {
    free ( buffer1 );
    free ( buffer2 );
    return -1;
  }

  if ( filehd2 == NULL )
  {
    free ( buffer1 );
    free ( buffer2 );
    fclose ( filehd1 );
    return -1;
  }

  while ( 1 )
  {
    readlen1 = fread ( buffer1, 1, 16384, filehd1 );
    readlen2 = fread ( buffer2, 1, 16384, filehd2 );

    if ( readlen1 != readlen2 )
    {
      /* Files are different, because sizes read are different */
      free ( buffer1 );
      free ( buffer2 );
      fclose ( filehd1 );
      fclose ( filehd2 );
      return 1;
    }

    if ( memcmp ( buffer1, buffer2, readlen1 ) != 0 )
    {
      /* Files are different */
      free ( buffer1 );
      free ( buffer2 );
      fclose ( filehd1 );
      fclose ( filehd2 );
      return 1;
    }

    if ( ( readlen1 != 16384 ) ||
         ( readlen2 != 16384 ) ||
         ( feof ( filehd1 ) != 0 ) ||
         ( feof ( filehd2 ) != 0 ) )
    {
      /* End of files reached */
      free ( buffer1 );
      free ( buffer2 );
      fclose ( filehd1 );
      fclose ( filehd2 );
      return 0;
    }
  }
return 0;
}

/* ============================================================================================= */

void DiffListFiles ( struct Nodes *nodeptr, int rmflag )
{
struct Nodes       *posptr,
                   *anchorptr;

  while ( nodeptr != NULL )
  {
    posptr = nodeptr;
    anchorptr = nodeptr;

    /* While there are files with same size check all permutations of them */
    while ( anchorptr->samenext != NULL )
    {
      posptr = anchorptr;

      while ( posptr->samenext != NULL )
      {
        posptr = posptr->samenext;

        /* double detected */
        if ( DiffFiles ( anchorptr->name, posptr->name, anchorptr->length ) == 0 )
        {
          printf ( "identical files: %s (dir %i) and %s (dir %i) with size %lu\n",
                    anchorptr->name,
                    anchorptr->holdcnt,
                    posptr->name,
                    posptr->holdcnt,
                    anchorptr->length );

          if ( rmflag )
	  {
            printf ("delete file (dir %i): %s ? ", anchorptr->holdcnt, anchorptr->name );

            if ( !yesno ( ) )
	    {
              /* delete file 1 */
              if ( remove ( anchorptr->name ) != 0 )
	      {
                fprintf ( stderr, "could not remove %s\n", anchorptr->name );
	      }
	    }
            else
	    {
              printf ("delete file (dir %i): %s ? ", posptr->holdcnt, posptr->name );

              if ( !yesno ( ) )
	      {
                /* delete file 2 */
                if ( remove ( posptr->name ) != 0 )
	        {
                  fprintf ( stderr, "could not remove %s\n", posptr->name );
		}
	      }
	    }
	  }
        }
      }
      anchorptr = anchorptr->samenext;
    }
    nodeptr = nodeptr->next;
  }
}

/* ============================================================================================= */

void usage ( char *name, int x )
{
  fprintf( stderr, "version: %s\n", VERSION );
  fprintf( stderr, "usage: %s [-dhwV] dir [dir] [dir] ...\n\n", name );
  fprintf( stderr, "-d  delete one of the double files after asking which\n" );
  fprintf( stderr, "-h  help\n" );
  fprintf( stderr, "-w  wait after each dir before processing the next\n" );
  fprintf( stderr, "-V  version\n\n" );
  fprintf( stderr, "mail to: d.stolte@tu-bs.de for bugs or improvements\n" );
  exit ( x );
}

/* ============================================================================================= */

int main (int argc, char *argv[])
{
char		*dirname;
char		pwdname[PATH_MAX+1],
		absname[PATH_MAX+1];
char            c;
DIR		*dirptr;
struct dirent	*direntry;
struct stat     *statbuf;
int             argcnt,
                holdflag=0,
                holdcnt=0,
                rmflag=0;
struct Nodes    *listptr,
                *listposptr;

extern char *optarg;
extern int optind, opterr, optopt;

direntry = ( struct dirent* ) malloc ( sizeof ( struct dirent ) );
statbuf  = ( struct stat* )   malloc ( sizeof ( struct stat ) );

opterr = 0;

while ((c = getopt(argc, argv, "dhwV")) != -1)
{
  switch (c)
  {
    case 'd':
      rmflag = 1;
      break;
    case 'h':
      usage ( argv[0], 0 );
      break;
    case 'w':
      holdflag = 1;
      break;
    case 'V':
      fprintf( stderr, "version: %s\n", VERSION );
      exit ( 0 );
      break;
    case '?':
      usage ( argv[0], 1 );
      break;
  }
}

if ( ( argc - optind ) == 0 )
{
  usage ( argv[0], 1 );
}

listptr = InitList ( );

getcwd ( pwdname, PATH_MAX );

argcnt = optind;

while ( argc != argcnt )
{
  chdir ( pwdname );

  dirname = argv[argcnt];

  if ( holdflag )
  {
    printf ( "press return to read %s ", dirname );
    while ((c = getchar ()) != EOF && c != '\n')
    {
    }
  }

  holdcnt++;

  if ( chdir ( dirname ) !=0 )
  {
    fprintf ( stderr, "error: chdir %s\n", dirname );
  }
  else
  {
    dirptr = opendir ( "." );

    if ( dirptr == NULL )
    {
      fprintf ( stderr, "error: opendir ...\n" );
    }
    else
    {
      do
      {
        direntry = readdir ( dirptr );
        if ( direntry != NULL )
        {
          if ( stat ( direntry->d_name, statbuf ) != 0 )
	  {
            fprintf ( stderr, "error: stat ...\n" );
	  }
          else
	  {
            if ( ( ( statbuf->st_mode ) & S_IFREG ) !=0 )
	    {
               if ( dirname[ strlen ( dirname ) -1 ] != '/' )
	       {
                 sprintf ( absname, "%s/%s", dirname, direntry->d_name );
	       }
               else
	       {
                 sprintf ( absname, "%s%s", dirname, direntry->d_name );
	       }
               listposptr = PutList ( listptr, absname, statbuf->st_size, holdcnt );

               if ( listposptr != NULL )
	       {
                 listptr = listposptr;
	       }
	    }
	  }
        }
      }
      while ( direntry != NULL );
    }
  closedir ( dirptr );
  }
argcnt = argcnt + 1;
}

chdir ( pwdname );

DiffListFiles ( listptr, rmflag );

DelList ( listptr );
exit ( 0 );
}
