#!/usr/bin/perl
#
# Package for converting to .tgz file.

sub FixFields { my %fields=@_;
	# Nothing to do.

	return %fields;
}

sub Convert { my ($workdir,%fields)=@_;
	if ($scripts) {
		my $install_made=undef;
		my %scripttrans=(
			'doinst.sh' => 'POSTINST',
			'delete.sh' => 'POSTRM',
			'predelete.sh' => 'PRERM',
			'predoinst.sh' => 'PREINST',
		);
		foreach $script (keys(%scripttrans)) {
			if ($fields{$scripttrans{$script}}) {
				if (!$install_made) {
					Status("Setting up scripts.");
					mkdir "$fields{NAME}-$fields{VERSION}/install",0755
						|| Error("Unable to make install directory");
					$install_made=1;
				}
				open (OUT,">$workdir/install/$script") ||
					Error("$workdir/install/$script: $!");;
				print OUT $fields{$scripttrans{$script}};
				close OUT;
				chmod 0755,"$workdir/install/$script";
			}
		}
	}
}

# Passed the available info about the package in a hash, return the name of
# the tgz package that will be made.
sub GetPackageName { my %fields=@_;
	return "$fields{NAME}-$fields{VERSION}-$fields{RELEASE}.tgz";
}

# Build a tgz file.
sub Build { my (%fields)=@_;
	SafeSystem("tar czf ../".GetPackageName(%fields)." .");
}

# Install the passed tgz file.
sub Install { my $package=shift;
	if (-x "/sbin/installpkg") {
		SafeSystem("/sbin/installpkg $package");
	}
	else {
		print STDERR "Sorry, I cannot install the generated .tgz file,\n";
		print STDERR "\"$package\" because /sbin/installpkg is not\n";
		print STDERR "present. You can use tar to install it yourself.\n";
		exit 1; # otherwise alien will delete the package file on us.
	}
}

1
