#!/usr/bin/env perl
# Script ----------------------------------------------------------------------
# Description - Pwgrprep prints out a report regarding groups.
# License     - See LICENSE file for details.
#
# $Author: jayrfink $
# $Date: 2007/05/31 23:33:45 $
# $State: Exp $
#------------------------------------------------------------------------------

$SIG{'INT' } = 'interrupt';     $SIG{'QUIT'} = 'interrupt';
$SIG{'HUP' } = 'interrupt';     $SIG{'TRAP'} = 'interrupt';
$SIG{'ABRT'} = 'interrupt';     $SIG{'STOP'} = 'interrupt';

my @group_file = load_file("/etc/group");
my @groupnames;

for (my $i = 0; $i <@group_file; $i++) {
	my @temp = split(":", $group_file[$i]);
	push @groupnames, $temp[0];
}

format =
@<<<<<<<<<<<<<<<<<<<< @<<<<< @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$name,                $gid,  @who
                             @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<~~
.

$name = "Group Name";
$gid  = "Group ID";
@who  = "Members";
write();

for (my $j = 0; $j <@groupnames; $j++) {
	my ($grpname, $grpw, $ggid, @members);
	($grpname,
	 $grpw,
	 $ggid,
	 @members) = getgrnam($groupnames[$j]);

	$name = $grpname;
	$gid  = $ggid;
	@who  = @members;
	write();

}

sub interrupt {
    my($sig) = @_;
    die $sig;
    die;
}

sub load_file {
    my ($file) = shift; # what were reading
    my @flist;      # where were gonna stick it

    open(FILE, $file);
    @flist = <FILE>;
    close FILE;

    return(@flist); # send the list back to the caller
}

