#!/usr/bin/env perl
# Program ---------------------------------------------------------------------
# Description - Pwdf runs the df -sh commands across all valid home directories.
#               It does have an exclusion list at the top of the script.
#
# License     - See LICENSE file for details.
#
# $Author: jayrfink $
# $Date: 2007/05/31 23:33:45 $
# $State: Exp $
#------------------------------------------------------------------------------

$SIG{'INT' } = 'interrupt';     $SIG{'QUIT'} = 'interrupt';
$SIG{'HUP' } = 'interrupt';     $SIG{'TRAP'} = 'interrupt';
$SIG{'ABRT'} = 'interrupt';     $SIG{'STOP'} = 'interrupt';

# You need to change this list to exclude whatever you do not wish to see
my @exceptions = (
	"jdlw",
	"jqslee",
	"lem",
);

my @passwd_file = load_file("/etc/passwd");
my @usernames;

for (my $i = 0; $i <@passwd_file; $i++) {
		my @temp = split(":", $passwd_file[$i]);
		push (@usernames, $temp[0]);
}

for (my $i = 0; $i <@usernames; $i++) {
	my $m = 0;
	my $user = $usernames[$i];
	chomp($user);
	for (my $j = 0; $j <@exceptions; $j++) {
		if ($user eq $exceptions[$j]) {
			++$m;
		}
	}

	if ($m == 0) {
		push(@userland,$user);
	}
}

my ($name, $uid, $gid, $group, $homedir, $shell);



format =
@<<<<<<<< @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< @<<<<<<<<<<<<<<<<<<<<<<<<<<< 
$name,    $homedir,                       $used
.

$name    = "Name";
$homedir = "Home Directory";
$used    = "Space used in kb";
write();
	
for (my $i = 0; $i <@userland; $i++) {
	my @ui = usersysinfo($userland[$i]);
	my $du_output;
	my @temp;

	$name    = $ui[0];
	$homedir = $ui[4];
	if (-d $homedir) {
		$du_output = `du -s $homedir`;
		@temp = split(" ", $du_output);
		$used = $temp[0];		
	} else {
		$used = "na";
	}
	write();
	undef(@temp);
}

sub interrupt {
	my($sig) = @_;
	die $sig;
	die;
}

sub load_file {
	my ($file) = shift; # what were reading
	my @flist;      # where were gonna stick it

	open(FILE, $file);
	@flist = <FILE>;
	close FILE;

	return(@flist); # send the list back to the caller
}

sub usersysinfo {
	my ($uname) = shift;
	my ($name, $pass, $uid, $gid, $quota, $cname, $gcos, $dir, $shell);
	my ($grpname, $grpw, $ggid, @members);

	($name,
	 $pass,
	 $uid,
	 $gid,
	 $quota,
	 $cname,
	 $gcos,
	 $dir,
	 $shell) = getpwnam($uname);

	($grpname,
	 $grpw,
	 $ggid,
	 @members) = getgrgid($gid);

	chomp($name);
	chomp($uid);
	chomp($grpname);
	chomp($dir);
	chomp($shell);

	return ($name, $uid, $gid, $grpname, $dir, $shell);
}


