/* vim:tw=78:ts=8:sw=4:set ft=cpp:  */
/*
    Copyright (C) 2010 Ben Kibbey <bjk@luxsci.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02110-1301  USA
*/
#include <QApplication>
#include <QTimer>
#include "pwmdEdit.h"

PwmdEdit::PwmdEdit(int argc, char **argv) : QApplication(argc, argv)
{
    filename = QString::null;
    socket = QString::null;
    QStringList args = arguments();

    for (int i = 1; i < args.count(); i++) {
	QString arg = args.at(i);

	if (arg.at(0) == '-') {
	    switch (arg.at(1).toLatin1()) {
		case 's':
		    socket = args.at(++i);
		    break;
	    }
	}
	else
	    filename = arg;
    }

    PwmdDialog *d = new PwmdDialog(socket, filename, "pwmdEdit");

    d->exec();
    delete d;
    QTimer::singleShot(1, this, SLOT(quit()));
}
