/* vim:tw=78:ts=8:sw=4:set ft=c:  */
/*
    Copyright (C) 2006-2010 Ben Kibbey <bjk@luxsci.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02110-1301  USA
*/
#ifndef XML_H
#define XML_H

#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libxml/xpath.h>
#include <glib.h>

#include "gettext.h"
#define N_(msgid)	gettext(msgid)

struct element_list_s {
    GSList *list;
    gchar **elements;
    gchar *prefix;
    gint depth;
    gboolean resolving;
    gboolean recurse;
    gboolean verbose;
    gchar **req;
};

gint max_recursion_depth;

gpg_error_t new_root_element(xmlDocPtr doc, gchar *name);
xmlChar *new_document(void);
gpg_error_t list_root_elements(xmlDocPtr doc, GString **, gboolean);
gboolean valid_xml_element(xmlChar *element);
xmlNodePtr find_elements(xmlDocPtr doc, xmlNodePtr node,
	gchar **req, gpg_error_t *error, gboolean *target,
	xmlNodePtr (*found_fn)(xmlNodePtr, gchar **, gpg_error_t *, gchar **, void *),
	xmlNodePtr (*not_found_fn)(xmlNodePtr, gchar **, gpg_error_t *, void *),
	gboolean is_list_command, gint recursion_depth, void *data, gboolean stop);
xmlNodePtr find_root_element(xmlDocPtr doc, gchar ***req, gpg_error_t *error,
	gboolean *target, gint recursion_depth, gboolean stop);
xmlNodePtr create_elements_cb(xmlNodePtr node, gchar **elements,
	gpg_error_t *error, void *data);
xmlNodePtr create_target_elements_cb(xmlNodePtr node, gchar **elements,
	gpg_error_t *error, void *data);
gboolean is_literal_element(gchar **element);
gboolean valid_element_path(gchar **path, gboolean has_value);
xmlNodePtr find_text_node(xmlNodePtr node);
gpg_error_t create_path_list(xmlDocPtr doc, struct element_list_s *elements,
	gchar *path);
gpg_error_t recurse_xpath_nodeset(xmlDocPtr doc, xmlNodeSetPtr nodes,
	xmlChar *value, xmlBufferPtr *result, gboolean, const xmlChar *);
gpg_error_t convert_xml(gchar **xml, goffset *len);
gpg_error_t add_attribute(xmlNodePtr node, const gchar *name,
	const gchar *value);
xmlChar *node_has_attribute(xmlNodePtr n, xmlChar *attr);
gpg_error_t delete_attribute(xmlNodePtr n, const xmlChar *name);
gpg_error_t convert_elements(xmlDocPtr doc);
gpg_error_t validate_import(xmlNodePtr);
xmlNodePtr find_element(xmlNodePtr node, gchar *element, xmlNodePtr stop);
gpg_error_t update_element_mtime(xmlNodePtr n);
gpg_error_t unlink_node(xmlNodePtr n);

#endif
