/* vim:tw=78:ts=8:sw=4:set ft=c:  */
/*
    Copyright (C) 2006-2010 Ben Kibbey <bjk@luxsci.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02110-1301  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <string.h>
#include <pth.h>
#include <glib.h>
#include "pwmd_error.h"
#include "gettext.h"

#define N_(msgid)	gettext(msgid)

static gchar *_gpg_strerror(gpg_error_t rc)
{
    gchar ebuf[ERROR_BUFLEN], *ep;

    gpg_strerror_r(rc, ebuf, sizeof(ebuf));
    ep = g_strdup(ebuf);
    pth_cleanup_push(g_free, ep);
    return ep;
}

const gchar *pwmd_strerror(gpg_error_t e)
{
    gpg_err_code_t code = gpg_err_code(e);

    if (code >= GPG_ERR_USER_1 && code < gpg_err_code(EPWMD_MAX)) {
	switch (code) {
	    case GPG_ERR_USER_1:
		return N_("No file is open");
	    case GPG_ERR_USER_2:
		return N_("General LibXML error");
	    case GPG_ERR_USER_3:
		return N_("File modified");
	    default:
		return N_("Unknown error");
	}
    }

    return _gpg_strerror(e);
}
