/* vim:tw=78:ts=8:sw=4:set ft=c:  */
/*
    Copyright (C) 2006-2010 Ben Kibbey <bjk@luxsci.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02110-1301  USA
*/
#ifndef COMMANDS_H
#define COMMANDS_H

gboolean disable_list_and_dump;

gpg_error_t register_commands(assuan_context_t ctx);
void cleanup_assuan(assuan_context_t ctx);
gpg_error_t try_xml_decrypt(assuan_context_t ctx, struct crypto_s *,
	gpointer *dst, goffset *dst_len);
void unlock_file_mutex(struct client_s *client);
gpg_error_t lock_file_mutex(struct client_s *client);
file_header_internal_t *read_file_header(const gchar *filename, gboolean v1,
	gpg_error_t *rc);
gboolean do_compress(assuan_context_t ctx, gint level, gpointer data,
	guint size, gpointer *out, gulong *outsize, gint *error);
gboolean valid_filename(const gchar *filename);
void cleanup_client(struct client_s *client);
gpg_error_t update_save_flags(const gchar *filename,
	struct crypto_s *crypto);

#endif
