/* vim:tw=78:ts=8:sw=4:set ft=c:  */
/*
    Copyright (C) 2006-2010 Ben Kibbey <bjk@luxsci.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02110-1301  USA
*/
#ifndef RCFILE_H
#define RCFILE_H

#ifdef WITH_PINENTRY
#define DEFAULT_PIN_TIMEOUT	30
#endif

#ifdef HAVE_MLOCKALL
extern gboolean disable_mlock;
#endif
extern gchar *logfile;
extern gchar *rcfile;
extern gboolean cmdline;
extern gint max_recursion_depth;
extern gboolean disable_list_and_dump;

gboolean parse_rcfile_keys();
gboolean get_key_file_boolean(const gchar *section, const gchar *what);
gdouble get_key_file_double(const gchar *section, const gchar *what);
gint get_key_file_integer(const gchar *section, const gchar *what);
gchar *get_key_file_string(const gchar *section, const gchar *what);
gpg_error_t parse_rcfile_keyfile(struct crypto_s *, const gchar *filename, gboolean import);
void clear_rcfile_keys();
GKeyFile *parse_rcfile(gboolean specified);
void set_rcfile_defaults(GKeyFile *kf);
void setup_logging(GKeyFile *kf);

#endif
