/* vim:tw=78:ts=8:sw=4:set ft=c:  */
/*
    Copyright (C) 2006-2010 Ben Kibbey <bjk@luxsci.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02110-1301  USA
*/
#ifndef LOCK_H
#define LOCK_H

#include <pth.h>
#include <assert.h>
#include <errno.h>
#include "cache.h"

#ifdef DEBUG
#define MUTEX_LOCK_DEBUG(m) \
    log_write("%s(%i): %s(): LOCK %p", __FILE__, __LINE__, __FUNCTION__, m);
#define MUTEX_UNLOCK_DEBUG(m) \
    log_write("%s(%i): %s(): UNLOCK %p", __FILE__, __LINE__, __FUNCTION__, m);
#else
#define MUTEX_LOCK_DEBUG(m)
#define MUTEX_UNLOCK_DEBUG(m)
#endif

#define CACHE_LOCK(ctx) MUTEX_LOCK(&cache_mutex)
#define CACHE_UNLOCK MUTEX_UNLOCK(&cache_mutex)

#define MUTEX_LOCK(m) \
    MUTEX_LOCK_DEBUG(m) \
    if (!pth_mutex_acquire(m, FALSE, NULL)) { \
	log_write("%s(%i): %s: LOCK", __FILE__, __LINE__, strerror(errno)); \
	assert(0); \
    } \

#define MUTEX_UNLOCK(m) \
    MUTEX_UNLOCK_DEBUG(m) \
    if (!pth_mutex_release(m) && errno != EDEADLK) { \
	log_write("%s(%i): %s: UNLOCK", __FILE__, __LINE__, strerror(errno)); \
	assert(0); \
    }

#define MUTEX_TRYLOCK(ctx, m, rc) \
    if (!pth_mutex_acquire(m, TRUE, NULL)) { \
	if (errno == EBUSY) { \
	    if (ctx) {\
		rc = send_status(ctx, STATUS_LOCKED, NULL); \
		if (!rc) { \
		    MUTEX_LOCK(m); \
		} \
	    } \
	} \
	else { \
	    log_write("%s(%i): %s: LOCK", __FILE__, __LINE__, __FUNCTION__); \
	    assert(0); \
	} \
    } \
    else { \
	MUTEX_LOCK_DEBUG(m) \
    }

#endif
