/* vim:tw=78:ts=8:sw=4:set ft=c:  */
/*
    Copyright (C) 2006-2010 Ben Kibbey <bjk@luxsci.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02110-1301  USA
*/
#ifndef PWMD_ERROR_H
#define PWMD_ERROR_H

#include <gpg-error.h>

#define ERROR_BUFLEN	255

#define PWMD_ERR_SOURCE		GPG_ERR_SOURCE_USER_1

#define EPWMD_BADKEY		GPG_ERR_INV_PASSPHRASE
#define EPWMD_COMMAND_SYNTAX	GPG_ERR_SYNTAX
#define EPWMD_ELEMENT_NOT_FOUND	GPG_ERR_ELEMENT_NOT_FOUND
#define EPWMD_CACHE_NOT_FOUND	GPG_ERR_NOT_FOUND
#define EPWMD_ATTR_SYNTAX	GPG_ERR_SYNTAX
#define EPWMD_ATTR_NOT_FOUND	GPG_ERR_NOT_FOUND
#define EPWMD_INVALID_FILENAME	GPG_ERR_INV_VALUE
#define EPWMD_EMPTY_ELEMENT	GPG_ERR_NO_VALUE
#define EPWMD_INVALID_ELEMENT	GPG_ERR_INV_VALUE
#define EPWMD_LOOP		GPG_ERR_ELOOP
#define EPWMD_NO_FILE		GPG_ERR_USER_1
#define EPWMD_LIBXML_ERROR	GPG_ERR_USER_2
#define EPWMD_FILE_MODIFIED	GPG_ERR_USER_3
#define EPWMD_MAX		GPG_ERR_USER_4

const gchar *pwmd_strerror(gpg_error_t e);
gchar *_gpg_strerror(gpg_error_t rc);

#endif
