/* Only uncomment the following line if you modifed your hardware! */

#define HARDWARE_MODIFICATION

/* drivers for the philips TV1000 TV card */

#include "sys_head.h"

int tda8425_r8 = 0x01;/* bit 5 mute, bit 0 input select,
						/* 0 is TV, 1 is VCR */
						/* bit 5 must be set (mute) so that the first time
						/* mute is pressed, mute is active */ 
int tda9051_r9 = 0xe0;/* bit 0 input select, 0 is VTR, 1 is TV */

int tv1000_bass;
int tv1000_treble;
int tv1000_volume;
int tv1000_saturation;
int tv1000_brightness;
int tv1000_contrast;
int tv1000_channel;
int tv1000_frequency;
int tv1000_external;
int tv1000_mute;
int tv1000_external_direct;
int tv1000_fine_tune;
int channel_frequencies[100];
int channel_offsets[100];
static int regval;

/* iic chips detected:
decimal hex type function
130 82 TDA8425 sound control

136 88 TDA4680 color control
137 89 ,,

138 8a SAA9051 multi standard decoder
139 8b ,,

140 8c
141 8d ,,

186 ba XXXXXXX on screen display
187 bb ''

190 be XXXXXXX ???? PAL decoder ????
191 bf ,,

192 c0
193 c1 ,,

194 c2
195 c3 ,,
*/

/*
 * Address Chip    Registers
 *
 * 0x82 ?? TDA8425 sound control
 *                 0x00: volume     (range: 0xDA..0xF9)
 *                 0x01: volume     (range: 0xDA..0xF9)
 *                 0x02: bass       (bit 0..3: data, bit 4..7: have to be high)
 *                 0x03: treble     (bit 0..3: data, bit 4..7: have to be high)
 *                 0x04: reserved
 *                 0x05: reserved
 *                 0x06: reserved
 *                 0x07: reserved
 *                 0x08: sound src  (bit 5: muting, bit 0: internal/external)
 *
 * 0x88    TDA4680 color control
 *                 0x00: brightness (bits: 0..5)
 *                 0x01: saturation (bits: 0..5)
 *                 0x02: contrast   (bits: 0..5)
 *                 0x03: unknown    (0x22)
 *                 0x04: red        (bits: 0..5)
 *                 0x05: green      (bits: 0..5)
 *                 0x06: blue       (bits: 0..5)
 *                 0x07: unknown    (0x20)
 *                 0x08: unknown    (0x20)
 *                 0x09: unknown    (0x20)
 *                 0x0A: unknown    (0x30)
 *                 0x0B: unknown    (0x00)
 *                 0x0C: unknown    (0xCD)
 *                 0x0D: unknown    (0x10)
 *                 0x0E: reserved
 *                 0x0F: reserved
 *
 * 0x8A    SAA9051 multi-standard decoder
 *                 0x00: increment delay
 *                 0x01: HSY start time
 *                 0x02: HSY stop time
 *                 0x03: HC start time
 *                 0x04: HC stop time
 *                 0x05: HS start time (after PHI1)
 *                 0x06: hor.peaking: by  pf  bp2  bp1 cor2 cor1 ap2   ap1
 *                 0x07: hue control
 *                 0x08: control1:    hpll fs  vtr co  alt  ypn  ccfr1 ccfr0
 *                 0x09: control2:    vnl  oey oec -   cl   afcc ss1   ss0
 *                 0x0a: control3:    syc  ct  yc  ss3 ss2  ydl2 ydl1  ydl0
 *                 0x0b: secam delay compensation
 *                 0x0c: reserved
 *                 0x0d: reserved
 *                 0x0e: reserved
 *                 0x0f: reserved
 *
 * 0xBA            on screen display
 *                 unknown
 *
 * 0xC2            tuner frequency control
 *                 frequency resolution is 1/16 MHz (62,5kHz)
 *                 frequency is set by transmitting four bytes
 *                  1,2: (frequency+39MHz)*16/10MHz
 *                    3: 0x8E or 0xCE
 *                    4: range: [ 48Mhz..174MHz] -> 0xA0
 *                              (174MHz..457MHz) -> 0x90
 *                              [457MHz..855MHz] -> 0xA0
 *
 * TDA8708? one of three video selector, agc, 30 MHz 8 bits a/d, not on iic bus
 *	
 * Unidentified chips:
 *   MN4780
 *   SAA9060
 *   SAA9057
 *   PCA8510
 *   TDA4566
 *   TDA7053
 *
MN3780
XXAC9322
SAA9057A
SAA9065
SAA9051
TDA4680WP
TDA2825


*/


int tv1000_ini()
{
static unsigned char tv1000_ini_data[] =
{
/* control2
* VNL:       ACTIVE
* D,BL,HS,VS:ACTIVE
* UV0..3:    ACTIVE
* CL:        CO controls color
* AFCC:      LOW spikes
* source:    0,4,8,12
*/

/* TDA8708 sound control*/
0x82, 0, 233, /* 0 - 31 0xda (218) + 16 left volume */
0x82, 1, 233, /* 0 - 31 0xda (218) + 15 right volume */
0x82, 2, 248, /* 0 - 15 255 - 7 bass */
0x82, 3, 248, /* treble */
0x82, 4, 0x00,/* reserved */
0x82, 5, 0x00,/* reserved */
0x82, 6, 0x00,/* reserved */
0x82, 7, 0x00,/* reserved */
0x82, 8, 0x01, /* bit 5 mute, bit 0 internal / external */

/* TDA4680 color control */
0x88, 0, 12, /* brightness */
0x88, 1, 40, /* saturation */
0x88, 2, 10, /* contrast */
0x88, 3, 0x22,/* unknown */
0x88, 4, 31, /* red */
0x88, 5, 31, /* green */
0x88, 6, 31, /* blue */
0x88, 7, 0x20,/* unknown */
0x88, 8, 0x20,/* unknown */
0x88, 9, 0x20,/* unknown */
0x88, 10, 0x30,/* unknown */
0x88, 11, 0x00,/* unknown */
0x88, 12, 0xCD,/* unknown */
0x88, 13, 0x10,/* unknown */
0x88, 14, 0x00,/* reserved */
0x88, 15, 0x00,/* reserved */

/* SAA9051 multi-standard decoder */
0x8A, 0, 0x64,/* increment delay */
/*0x8A, 1, 0x35,/* HSY start time */
0x8A, 1, 0xFF,/* HSY start time */
/*0x8A, 1, 0x07,/* HSY start time */

0x8A, 2, 0x0A,/* HSY stop  time */
0x8A, 3, 0xF8,/* HC  start time */
0x8A, 4, 0xCD,/* HC  stop  time */
0x8A, 5, 0xFE,/* HS  start time */
0x8a, 6, 0x00,/* hor peaking: !by !pf !bp2 !bp1 !cor2 !cor1 !ap2 !ap1 */
0x8A, 7, 0X00,/* hue control: a77 a76 a75 a74 a73 a72 a71 a70 */
0x8a, 8, 0x78,/* control 1: !hpll fs vtr co alt !ypn !ccfr1 !ccfr0 */
0x8A, 9, 0xE0,/* control2: vnl oey oec - cl afcc ss1 ss0 */
0x8a, 10, 0x00,/* control 3: syc ct yc ss3 ss2 ydl2 ydl1 ydl0 */
0x8A, 11, 0x00,/* secam delay compensation */
0x8A, 12, 0x00,/* reserved */
0x8A, 13, 0x00,/* reserved */
0x8A, 14, 0x00,/* reserved */
0x8A, 15, 0x00,/* reserved */

/* On screen display */
0xBA, 0x79, 0x42,/* clear screen */

/* ???? PAL decoder ? affects color, colorphase contrast?, blacklevel */
0xbe, 0, 0x00,
0xbe, 1, 0x00,
0xbe, 2, 0x00,
0xbe, 3, 0x01,/* bit 0 must be one else wrong color phase (no pal switch?) */

0xFF};
int address;
int a, i;
unsigned char *ptr;

tiicini();
ptr = tv1000_ini_data;
while(1)
	{
	address = *ptr;
	if(address == 0xff) break;
	ptr++;	
	tiicsnd(address, 2, ptr);
	ptr += 2;
	}

tda8425_r8 = 0x01;/* bit 5 mute, bit 0 internal / external */
tda9051_r9 = 0xe0;/* bit 0 input select, 0 = VTR, 1 = TV */
tv1000_volume = 15;/* internal volume philips tv1000 TV card */ 
tv1000_bass = 8;
tv1000_treble = 8;
tv1000_saturation = 40;
tv1000_brightness = 12;
tv1000_contrast = 10;
tv1000_mute = 0;
tv1000_channel = 0;

tv1000_set_channel(tv1000_channel);
do_it();
return(1);
}/* end function tv1000_ini */


int tv1000_save_preferences_to_file(char *filename)
{
FILE * preferencesfile;
char temp[512];
char path_filename[512];
extern char home_dir[];

sprintf(path_filename, "%s/.tv1000/%s", home_dir, filename);

preferencesfile = fopen(path_filename, "r");
if(preferencesfile)
	{
	fclose(preferencesfile);
	fprintf(stdout, "\n%s exists, overwrite (y/n)", path_filename);
	if( toupper(temp[0] ) != 'Y')
		{
		fprintf(stdout, "\ncommand cancelled");
		return(0);
		}
	}
preferencesfile = fopen(path_filename, "w");
if(! preferencesfile) return(0);
fprintf(preferencesfile, "volume %d\n", tv1000_volume);
fprintf(preferencesfile, "bass %d\n", tv1000_bass);
fprintf(preferencesfile, "treble %d\n", tv1000_treble);
fprintf(preferencesfile, "saturation %d\n", tv1000_saturation);
fprintf(preferencesfile, "brightness %d\n", tv1000_brightness);
fprintf(preferencesfile, "contrast %d\n", tv1000_contrast);
fprintf(preferencesfile, "mute %d\n", tv1000_mute);
fprintf(preferencesfile, "external %d\n", tv1000_external);
fprintf(preferencesfile, "channel %d\n", tv1000_channel);
fclose(preferencesfile);
return(1);
}


tv1000_load_preferences_from_file(char *filename)
{
FILE * preferencesfile;
char ii[3];
int was_input;
char path_filename[512];
extern char home_dir[];

sprintf(path_filename, "%s/.tv1000/%s", home_dir, filename);
preferencesfile = fopen(path_filename, "r");
if(! preferencesfile)
	{
	fprintf(stdout, "\nCannot open %s", path_filename);
	return(0);
	}
fscanf(preferencesfile, "volume %d\n", &tv1000_volume);
fscanf(preferencesfile, "bass %d\n", &tv1000_bass);
fscanf(preferencesfile, "treble %d\n", &tv1000_treble);
fscanf(preferencesfile, "saturation %d\n", &tv1000_saturation);
fscanf(preferencesfile, "brightness %d\n", &tv1000_brightness);
fscanf(preferencesfile, "contrast %d\n", &tv1000_contrast);
fscanf(preferencesfile, "mute %d\n", &tv1000_mute);
fscanf(preferencesfile, "external %d\n", &was_input);
fscanf(preferencesfile, "channel %d\n",  &tv1000_channel);
fclose(preferencesfile);

tv1000_set_volume(tv1000_volume, 3);
tv1000_set_bass(tv1000_bass);
tv1000_set_treble(tv1000_treble);
tv1000_set_saturation(tv1000_saturation);
tv1000_set_brightness(tv1000_brightness);
tv1000_set_contrast(tv1000_contrast);
tv1000_set_mute(tv1000_mute);
tv1000_set_channel(tv1000_channel);
/* this comes last and overrules a possible not channel 0 (aux)
/* so if for example aux was selected and channel 2, aux is set */
/* this situation can be invoked by selecting channel 2 and then pressing
/* 'e' (for extrnal) */
tv1000_set_input(was_input);

return(1);
}


int load_external_internal_preferences_from_file(char *filename)
{
FILE * preferencesfile;
char temp[512];
char ii[3];
int was_input;
char path_filename[512];
extern char home_dir[];

sprintf(path_filename, "%s/.tv1000/%s", home_dir, filename);
preferencesfile = fopen(path_filename, "r");
if(! preferencesfile)
	{
	fprintf(stdout, "\nCannot open %s", path_filename);
	return(0);
	}
fscanf(preferencesfile, "volume %d\n", &tv1000_volume);
fscanf(preferencesfile, "bass %d\n", &tv1000_bass);
fscanf(preferencesfile, "treble %d\n", &tv1000_treble);
fscanf(preferencesfile, "saturation %d\n", &tv1000_saturation);
fscanf(preferencesfile, "brightness %d\n", &tv1000_brightness);
fscanf(preferencesfile, "contrast %d\n", &tv1000_contrast);
fclose(preferencesfile);

tv1000_set_volume(tv1000_volume, 3);
tv1000_set_bass(tv1000_bass);
tv1000_set_treble(tv1000_treble);
tv1000_set_saturation(tv1000_saturation);
tv1000_set_brightness(tv1000_brightness);
tv1000_set_contrast(tv1000_contrast);

return(1);
}


int tv1000_set_adc_input(int input)
{
char ii[3];

/* HARDWARE MODIFICATION  BOARD pin 16 TDA8708 (ana in 0) was blown up
/* due to no input protection (bad one philips)
/* now using input ana in 2 (pin 18).
/* because SS1 not connected to TDA8708:
/* TDA8708 pin 14 disconnected from SS0 and connected to +5.
/* TDA8708 pin 15 disconnected from ground and connected to SS0.
/* VCR video disconnected from pin 16 and connected to TDA8708 pin 18,
/* and pin 16 floating.
/* pin 14 ana select 0   was SS0    now +5
/* pin 15 ana select 1   was GND    now SS0
/* pin 16 ana in 0       was VCR    now float
/* pin 17 ana in 1       was TV     now TV
/* pin 18 ana in 2       was float  now VCR
/*
/* SS1 not used!!
/* SS0 (pin 15)  source  input pin
/* 0             TV      17
/* 1             VCR     18
/* So: input is 1 = TV, input is 0 = VCR 
*/

/* modify registers */
tda9051_r9 &= 252; /* reset bit 1 and bit 0 */
tda9051_r9 += input;/* SS1 is bit 1, SS0 is bit 0 */

/* select video */
ii[0] = 9;
ii[1] = tda9051_r9;
tiicsnd(138, 2, ii);

return(1);
}


int tv1000_set_input(int external)
{
char ii[3];

if(external)/* VCR */
	{
	tda8425_r8 |= 1;
#ifdef HARDWARE_MODIFICATION
	tv1000_set_adc_input(1);/* ss0 x, ss1 1 */
#else
	tda9051_r9 &= 254;
#endif
	}
else /* TV */
	{
	tda8425_r8 &= 254;
#ifdef HARDWARE_MODIFICATION
	tv1000_set_adc_input(0);
#else
	tda9051_r9 |= 1;
#endif
	}

#ifndef HARDWARE_MODIFICATION
/* select video */
ii[0] = 9;
ii[1] = tda9051_r9;
tiicsnd(138, 2, ii);
#endif

/* select sound */
ii[0] = 8;
ii[1] = tda8425_r8;
tiicsnd(130, 2, ii);

return(1);
}


int tv1000_set_frequency(int frequency)
{
char ii[3];
int frq;
int band;

/* frequency resolution is 1/16 MHz (62,5kHz) */
 
frq = (frequency * 16 + 5) / 10 + 0x0270;

band = 0x90;/* VHF 1 */
if(frq >= 0x1f00) band = 0x30;/* => 475 MHz UHF*/
if(frq <= 0xd50) band = 0xa0; /* <= 174 MHz VHF 2*/

fprintf(stdout, "frequency=%d frq=%d band=%d\n", frequency, frq, band);

ii[0] = (frq >> 8) & 0xFF;
ii[1] = frq;
/*ii[2] = 0xce;*/
ii[2] = 0x8e;
ii[3] = band;
tiicsnd(0xc2, 4, ii);

return(1);
}/* end function tv1000_set_frequency */


int tv1000_set_channel(int channel)
{
int frequency;
FILE *programsfile;
int a, position, data;
char path_filename[512];
extern char home_dir[];

/* if channel is 0, switch to aux, else to TV */ 
if(channel == 0) /* aux */
	{
	tv1000_external = 1;
	tv1000_set_input(tv1000_external);
	}
else /* TV */
	{
	tv1000_external = 0;
	tv1000_set_input(tv1000_external);
	}	

sprintf(path_filename, "%s/.tv1000/%s", home_dir, "programs.dat");
programsfile = fopen(path_filename, "r");
if(! programsfile)
	{
	fprintf(stdout, "\nCannot open file %s\n", path_filename);

	switch(channel)
		{
		case 1:
			frequency = 6150;
			break;
		case 2:
			frequency = 6390;
			break;
		case 3:
			frequency = 6630;
			break;
		case 4:
			break;		
		}
	}/* end no programs.dat */	
else
	{
	/* read in the file */
	while(1)
		{
		a = fscanf(programsfile, "%d %d\n", &position, &data);
/*
fprintf(stdout, "a=%d position=%d data[b]=%d\n",\
a, position, data);
*/
 		if(a == EOF) break;
		channel_frequencies[position] = data;	
		}
	fclose(programsfile);
	
	frequency = channel_frequencies[channel] + channel_offsets[channel];
	}/* end programs.dat found */

tv1000_set_frequency(frequency);

return(1);
}/* end function tv1000_set_channel */


int tv1000_set_fine_tune(int finetune)
{
/* modify channel amd set */

FILE *fi;
char path_filename[512];
extern char home_dir[];

sprintf(path_filename, "%s/.tv1000/%s", home_dir, "fine");
fi = fopen(path_filename, "w");
fprintf(fi, "%d\n", tv1000_fine_tune);
fclose(fi);

channel_offsets[tv1000_channel] = tv1000_fine_tune;
tv1000_set_channel(tv1000_channel);
return(1);
}/* end function tv1000_set_fine_tune */


int tv1000_read_all_iic_chips()
{
int a, b;
int i, j, q;
char ii[20], jj[20];
FILE * chipsfile;
char path_filename[512];
extern char home_dir[];

sprintf(path_filename, "%s/.tv1000/%s", home_dir, "chips.read.data.txt");
chipsfile = fopen(path_filename, "w");
if(!chipsfile) fprintf(stdout,\
"\nCannot open file %s for write\n", path_filename);
fprintf(stdout, "\n");
for(i = 0; i < 256; i++)
	{
	if(tiicrcv(i, 16, ii) )
		{
		fprintf(stdout, "tv1000_search_iic_chips: found address %d\n", i);
		if(chipsfile) fprintf(chipsfile, "%d %x\n", i, i);
		if( (i % 2) == 1)/* odd, readable */
			{
			for(j = 0; j < 16; j++)/* pointer registers */
				{

				/* read register pointed to */
				a = ii[j] & 0xff;
				fprintf(chipsfile,\
				"pointer=%d data=%d %02x\n",j, ii[j], a);
				continue;
/*
				jj[0] = i;
				if(! tiicsnd(i, 1, jj) )
					{
					fprintf(chipsfile, "no tiicsnd j=%d\n", j);
					continue;
					}
*/
				jj[0] = j;
				if(tiicrcv(i, 2, jj) )
					{
					/* read register pointed to */
					a = jj[1] & 0xff;
					fprintf(chipsfile,\
					"pointer=%d data=%d %02x\n",j, jj[1], a);
					}/* end for all registers */
				else
					{
					fprintf(chipsfile, "no tiicrcv j=%d\n", j);
					}
				}
			}/* end if odd, readable */
		}/* end if chip address present */
	}/* end for all iic chip addresses */
if(chipsfile) fclose(chipsfile);
fprintf(stdout, "Ready\n");
return(1);
}/* end function tv1000_read_all_iic_chips */


int tv1000_search_iic_chips()
{
int i;
char ii[3];
FILE * chipsfile;
char path_filename[512];
extern char home_dir[];

sprintf(path_filename, "%s/.tv1000/%s", home_dir, "chips.file.txt");
chipsfile = fopen(path_filename, "w");
if(!chipsfile) fprintf(stdout, "\nCannot open file %s for write\n",\
path_filename);
fprintf(stdout, "\n");
for(i = 0; i < 256; i++)
	{
	if(tiicsnd(i, 0, ii) )
		{
		fprintf(stdout, "tv1000_search_iic_chips: found address %d\n", i);
		if(chipsfile) fprintf(chipsfile, "%d %x\n", i, i);
		}
	}
if(chipsfile) fclose(chipsfile);
fprintf(stdout, "Ready\n");
return(1);
}/* end function tv1000_search_iic_chips */


int tv1000_step_register(int address, int reg)
{
int i;
char ii[3];
FILE *tracefile;
char path_filename[512];
extern char home_dir[];

tv1000_set_screen(1);
for(i = 0; i < 255; i++)
	{
	sprintf(path_filename, "%s/.tv1000/%s", home_dir, "tv1000_trace");
	tracefile = fopen(path_filename, "a");
	fprintf(tracefile, "%d ", i);
	if(tracefile) fclose(tracefile);
	ii[0] = reg;
	ii[1] = i;
	tiicsnd(address, 2, ii);
	usleep(100000);
	}
return(1);
}/* end function tv1000_step_registers */


int tv1000_set_saturation(int saturation)
{
char ii[3];

if(saturation < 0) saturation = 0;
if(saturation > 63) saturation = 63;

ii[0] = 1;
ii[1] = saturation;

tiicsnd(136, 2, ii);
return(1);
}


int tv1000_set_brightness(int brightness)
{
char ii[3];

if(brightness < 0) brightness = 0;
if(brightness > 63) brightness = 63;

ii[0] = 0;
ii[1] = brightness;

tiicsnd(136, 2, ii);
return(1);
}


int tv1000_set_reg(int value)
{
char ii[3];

if(value) if(regval < 255) regval++;
else if(regval > 0) regval--;
ii[0] = 0;
ii[1] = regval;
tiicsnd(0xba, 2, ii);
fprintf(stdout, "value=%d\n", value);
}

int tv1000_set_contrast(int contrast)
{
char ii[3];

if(contrast < 0) contrast = 0;
if(contrast > 63) contrast = 63;

ii[0] = 2;
ii[1] = contrast;

tiicsnd(136, 2, ii);
return(1);
}


int tv1000_set_mute(int mute)
{
char ii[3];

if(mute) tda8425_r8 |= 32;
else tda8425_r8 &= (255 - 32);/* bit 5, 1 = mute*/

/* write to tv1000 */
ii[0] = 8;
ii[1] = tda8425_r8;
tiicsnd(130, 2, ii);

return(1);
}/* end function tv1000_mute_toggle */


int tv1000_set_volume(int volume, int direction)
{
/* direction: bit 0 is left, bit 1 is right */
int iv1;
char temp[512];
char ii[3];

/* address TDA8425 is 0x82 (130d) */
/* volume range 0xda to 0xf9 (218 to 249) this is 31 steps */

if(volume < 0) volume = 0;
if(volume > 31) volume = 31;

iv1 = volume + 0xda;/* offsett */

if(direction & 1)/* left*/
	{
	ii[0] = 0x00;
	ii[1] = iv1;
	tiicsnd(130, 2, ii);
	}
if(direction & 2)/* right */
	{
	ii[0] = 0x01;
	ii[1] = iv1;
	tiicsnd(130, 2, ii);
	}
return(1);
}/* end function tv1000_set_volume */


int tv1000_set_bass(int bass)
{
int iv1;
char temp[512];
char ii[3];

/* address TDA8425 is 0x82 (130d) */
/* bass range is 15 steps */

if(bass < 0) bass = 0;
if(bass > 15) bass = 15;

iv1 = bass;
iv1 |= 0xf0;/* bit 0 - 3 bass, rest high */
ii[0] = 0x02;
ii[1] = iv1;
tiicsnd(130, 2, ii);
return(1);
}/* end function tv1000_set_bass */


int tv1000_set_treble(int treble)
{
int iv1;
char temp[512];
char ii[3];

/* address TDA8425 is 0x82 (130d) */
/* treble range is 31 steps */

if(treble < 0) treble = 0;
if(treble > 15) treble = 15;

/* calculate step value */
iv1 = treble;
iv1 |= 0xf0;/* bit 0 - 3 treble, rest high */
ii[0] = 0x03;
ii[1] = iv1;
tiicsnd(130, 2, ii);
return(1);
}/* end function tv1000_set_treble */


int send_text_to_on_screen_display(char *text)
{
char ii[3];
char *ptr;
int c;

ptr = text;
while(1)
	{
	c = *ptr++;
	if(c == 0) break;
	if(c == ' ')
		{
		ii[0] = 8;
		tiicsnd(0xba, 1, ii);
		ii[0] = 0x1c;
		ii[1] = 0xff;
		tiicsnd(0xba, 2, ii);
		}
	else
		{
		ii[0] = 8;/* r8 */
		ii[1] = c + 0x80;/* character */
		tiicsnd(0xba, 2, ii);
		}
    }     

return(1);
}/* end function send_text_to_on_screen_display */


int do_it()
{
char ii[10];


ii[0] = 0x42;
tiicsnd(0xba, 1, ii);
ii[0] = 0x78;
ii[1] = 0x20;
ii[2] = 0x30;
tiicsnd(0xba, 3, ii);
ii[0] = 0x79;
ii[1] = 0x9B;
ii[2] = 0xAC;
ii[3] = 0xB5;
tiicsnd(0xba, 4, ii);
ii[0] = 0x50;
tiicsnd(0xba, 1, ii);
ii[0] = 0x78;
ii[1] = 0x4E;
tiicsnd(0xba, 2, ii);
ii[0] = 0x18;
tiicsnd(0xba, 1, ii);
ii[0] = 0x1C;
ii[1] = 0xFF;
tiicsnd(0xba, 2, ii);
ii[0] = 0x18;
ii[1] = 0x80 | '<';
tiicsnd(0xba, 2, ii);
ii[0] = 0x18;
ii[1] = 0x80 | '>';
tiicsnd(0xba, 2, ii);
ii[0] = 0x18;
tiicsnd(0xba, 1, ii);
ii[0] = 0x1D;
ii[1] = 0xFF;
tiicsnd(0xba, 2, ii);
ii[0] = 0x02;
ii[1] = 0x80 | '~';
tiicsnd(0xba, 2, ii);
ii[0] = 0x20;
ii[1] = 0xFF;/* was fff */
tiicsnd(0xba, 2, ii);
ii[0] = 0x79;
ii[1] = 0x9B;
ii[2] = 0xAC;
ii[3] = 0xB5;
tiicsnd(0xba, 4, ii);
ii[0] = 0x50;
tiicsnd(0xba, 1, ii);
ii[0] = 0x78;
ii[1] = 0x4E;
tiicsnd(0xba, 2, ii);
ii[0] = 0x08;
tiicsnd(0xba, 1, ii);
ii[0] = 0x1C;
ii[1] = 0xFF;
tiicsnd(0xba, 2, ii);
                            
return(1);

ii[0] = 0x78;
ii[1] = 0x20;
ii[2] = 0x30;
ii[3] = 0xff;
ii[4] = 0xff;
ii[5] = 0xff;
ii[6] = 0xff;
ii[7] = 0xff;
tiicsnd(0xba, 8, ii);
send_text_to_on_screen_display("Ha die pantel.");
return(1);
}


