/* iic routines to drive philips tv1000 tv card */

#include "tv1000.h"

/*
Address Chip    Registers

 * 0x82 ?? TDA8425 sound control
 *                 0x00: volume     (range: 0xDA..0xF9)
 *                 0x01: volume     (range: 0xDA..0xF9)
 *                 0x02: bass       (bit 0..3: data, bit 4..7: have to be high)
 *                 0x03: treble     (bit 0..3: data, bit 4..7: have to be high)
 *                 0x04: reserved
 *                 0x05: reserved
 *                 0x06: reserved
 *                 0x07: reserved
 *                 0x08: sound src  (bit 5: muting, bit 0: internal/external)
 *
 * 0x88    TDA4680 color control
 *                 0x00: brightness (bits: 0..5)
 *                 0x01: saturation (bits: 0..5)
 *                 0x02: contrast   (bits: 0..5)
 *                 0x03: unknown    (0x22)
 *                 0x04: red        (bits: 0..5)
 *                 0x05: green      (bits: 0..5)
 *                 0x06: blue       (bits: 0..5)
 *                 0x07: unknown    (0x20)
 *                 0x08: unknown    (0x20)
 *                 0x09: unknown    (0x20)
 *                 0x0A: unknown    (0x30)
 *                 0x0B: unknown    (0x00)
 *                 0x0C: unknown    (0xCD)
 *                 0x0D: unknown    (0x10)
 *                 0x0E: reserved
 *                 0x0F: reserved
 *
 * 0x8A    SAA9051 multi-standard decoder
 *                 0x00: increment delay
 *                 0x01: HSY start time
 *                 0x02: HSY stop time
 *                 0x03: HC start time
 *                 0x04: HC stop time
 *                 0x05: HS start time (after PHI1)
 *                 0x06: hor.peaking: by  pf  bp2  bp1 cor2 cor1 ap2   ap1
 *                 0x07: hue control
 *                 0x08: control1:    hpll fs  vtr co  alt  ypn  ccfr1 ccfr0
 *                 0x09: control2:    vnl  oey oec -   cl   afcc ss1   ss0
 *                 0x0a: control3:    syc  ct  yc  ss3 ss2  ydl2 ydl1  ydl0
 *                 0x0b: secam delay compensation
 *                 0x0c: reserved
 *                 0x0d: reserved
 *                 0x0e: reserved
 *                 0x0f: reserved
 *
 * 0xBA            on screen display
 *                 unknown
 *
 * 0xC2            tuner frequency control
 *                 frequency resolution is 1/16 MHz (62,5kHz)
 *                 frequency is set by transmitting four bytes
 *                  1,2: (frequency+39MHz)*16/10MHz
 *                    3: 0x8E or 0xCE
 *                    4: range: [ 48Mhz..174MHz] -> 0xA0
 *                              (174MHz..457MHz) -> 0x90
 *                              [457MHz..855MHz] -> 0xA0
 *
 * Unidentified chips:
 *   TDA8708
 *   MN4780
 *   SAA9060
 *   SAA9057
 *   PCA8510
 *   TDA4566
 *   TDA7053
 *
 * What seems to be different to Rev. 2.0 boards, is the tuner frequency
 * control.
 *
 */

/*i/o used:

/*scl			bit 0 0x200
/*sdaout		bit 1 0x200
/*sdain			bit 1 0x200
*/

#include "sys_head.h"

#define IIC_BUS_DELAY	10000

int tvmode = 0;
int byte_to_port;


tiibeep(da)/*beep and return 0 if error cannot be printed, else return 1*/
int da;/*device address*/
{
int a,i,j;
return(1);
if((da == 130) || (da == 131)) a = 1;/* audio chip */
else if((da == 136) || (da == 137)) a = 2;/* color control chip */
else if((da == 138) || (da == 139)) a = 4;/* multi standard decoder chip */
else if((da == 0xba) || (da == 0xbb)) a = 5;/* on screen display chip */
else if((da == 0xc2) || (da == 0xc3)) a = 6;/* tuner frequency control chip */
else a = 1;
for(i = 0; i < a; i++)
	{
	beep(1,4000);
	usleep (500000);
   	}
return(1);
}

tiicini()
{
tsdah();
tsclh();
}

tbusdly(d)
int d;
{
int i;
for(i=0;i<d;i++)
	{
	d=d;
	}
}

tsdain()
{
register a;
a = inb(IO_PORT);
a &= 2;/*bit 1 only*/
if(a)byte_to_port |= 2;
else byte_to_port &= 253;
/*
if(a) fprintf(stdout, "\nHIGH %d", byte_to_port);
else fprintf(stdout, "\nLOW %d", byte_to_port);
*/
return(a);
}

tiicstart()
{
tsdal();
tscll();
}

tiicstop()
{
tsdal();
tsclh();
tsdah();
}

tsndbyte(d)
char d;
/*transmits one byte, scl must be low at start, scl is low at end*/
{
static char a,i;
a=d;
for(i=0;i<8;i++)/*each bit*/
	{
	if(!(a & 128))tsdal();/*high bit first*/
	else tsdah();
	a+=a;/*a=a*2*/
	tsclh();
	tscll();
	}
/*read ack bit*/
tsdah();
tsclh();
a=tsdain();
tscll();
if(a)return(0);/*no ack slave is error*/
return(1);/*ack slave is ok*/
}

trcvbyte(d,l)
char *d;
char l;/*last byte flag*/
{
static char b,i;
/*if last byte flag, then inverted ack bit is send,
/*scl must be low at start, scl is low at end
*/
tsdah();/*for read*/
b=0;
tscll();
for(i=0;i<8;i++)
	{
	tsclh();
	b+=b;/*shift left*/
	if(tsdain()) b++; /* set bit 0 */
	tscll();
	}
*d = b;
/*send ack bit*/
if(l)tsdah();
else tsdal();
tsclh();
tscll();
tsdah();
return(1);/*always true, data in *d*/
}

tiicsnd(a,n,d)/*address,annzahl,data array in ram*/
char a;
int n;
char d[];
{
static int i;

tiicstart();
if(!tsndbyte(a))
	{
	tiicstop();
	printf("\ntiicsnd: No ack. device address %d\n",a);
	tiibeep(a);
	return(0);
	}
for(i=0;i<n;i++)
	{
	if(!tsndbyte(d[i]))
		{
		tiicstop();
		printf("\ntiicsnd: No ack. data byte %d to device %d\n",d[i],a);
		tiibeep(a);
		return(0);
		}
	}
tiicstop();
return(1);/*ok*/
}

tiicrcv(a,n,d)/*address,anzahl,data ptr to char array*/
char a;
int n;
char *d;
{
static int i;
char t[80];
tiicstart();
/*write device address*/
if(!tsndbyte(a))
	{
	tiicstop();
	printf("\ntiicrcv: No ack. device address %d\n",a);
	tiibeep(a);
	return(0);
	}
tsdah();/*for read*/
for(i=0;i<n-1;i++)
	{
	trcvbyte(&d[i],0);
	}
trcvbyte(&d[i],1);
tiicstop();
return(1);
}

tscll()
{
register a;
a = inb(IO_PORT);
a &= 2;/* get sda */
if(a) byte_to_port |= 2;/* set bit 1 in byte_to_port if sda was high */
else byte_to_port &= 253;/* reset bit 1 */
byte_to_port &= 254;/* reset bit 0 */
outb(byte_to_port, IO_PORT);
tbusdly(IIC_BUS_DELAY);
}

tsclh()
{
register a;
a = inb(IO_PORT);
a &= 2;/* get sda */
if(a) byte_to_port |= 2;/* set bit 1 in byte_to_port if sda was high */
else byte_to_port &= 253;/* reset bit 1 */
byte_to_port |= 1;/* set bit 0 */
outb(byte_to_port, IO_PORT);
tbusdly(IIC_BUS_DELAY);
}

tsdal()
{
register a;
byte_to_port &= 253;/* reset bit 1 */
outb(byte_to_port, IO_PORT);
tbusdly(IIC_BUS_DELAY);
}

tsdah()
{
register char a;
byte_to_port |= 2;/* set bit 1 */
outb(byte_to_port, IO_PORT);
tbusdly(IIC_BUS_DELAY);
}


int tv1000_set_screen(int mode)
{
int byte_to_port = 0;

byte_to_port = inb(IO_PORT);

if(mode == 0) byte_to_port &= (255 - 4);/* computer */
if(mode == 1) byte_to_port |= 4;/* TV */	
outb(byte_to_port, IO_PORT);
return(1);
}/* end function tv1000_set_screen */


