
/*
 * SERVICE DESCRIPTION TABLE ROUTINES
 *
 * Copyright (C) 1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as dent@cosy.sbg.ac.at, or
 * Thomas Mirlacher, Jakob-Haringerstr. 2, A-5020 Salzburg,
 * Austria
 *
 *------------------------------------------------------------
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#include "sdt.h"
#include "descr.h"
#include "dvb.h"
#include "indentifier.h"
#include "decode.h"

extern int debug_flag;


extern dvb_descr_service_t *descr_service (char *buf, int len);
extern char *descr_country_availability (char *buf, int len);

static int _parse_sdt_descr (u_char *buf, u_int len, dvb_sdt_descr_t *dvb_sdt);


int parse_sdt (u_char *buf, dvb_sdt_t *dvb_sdt)
{
	sdt_t *sdt = (sdt_t *) buf;
	u_int loop_len, descr_len = 0;
	u_int sec_len;
	u_char *ptr = buf;
	
	sec_len = HILO (sdt->section_length);

	if (sdt->table_id != TID_SDT_ACT &&
	    sdt->table_id != TID_SDT_OTH) {
		return -1;
	}

	dvb_sdt->version = sdt->version_number;

	dvb_sdt->ts_id = HILO (sdt->transport_stream_id);
	dvb_sdt->orig_nw_id = HILO (sdt->original_network_id);

	ptr += SDT_LEN;

	while ((ptr - buf + 1) < sec_len) {
		dvb_sdt_descr_t *descr = calloc (1, sizeof (dvb_sdt_descr_t));
		sdt_descr_t *sdt_descr = (sdt_descr_t *) ptr;
		dvb_sdt_service_t *service;

		{ 
			dvb_sdt_service_t *ptr;

			service = calloc (1, sizeof (dvb_sdt_service_t));
			if ((ptr = dvb_sdt->service)) {
				while (ptr->next)
					ptr = ptr->next;
				ptr->next = service;
			} else
				dvb_sdt->service = service;

		}

		service->service_id = HILO (sdt_descr->service_id);
		service->free_ca_mode = sdt_descr->free_ca_mode;

		loop_len = HILO (sdt_descr->descriptors_loop_length);
		ptr += SDT_DESCR_LEN;

		descr_len = 0;
		service->descr = descr;
		while (descr_len < loop_len) {

			_parse_sdt_descr (ptr, loop_len - descr_len, descr);

			descr_len += get_descr_len(ptr) + DESCR_GEN_LEN;
			ptr += get_descr_len(ptr) + DESCR_GEN_LEN;
		}
	}

	return 0;
}

static int _parse_sdt_descr (u_char *ptr, u_int len, dvb_sdt_descr_t *descr)
{
	switch (get_descr(ptr)) {
		case DESCR_STUFFING:
			break;
		case DESCR_COUNTRY_AVAIL: 
			if (descr->country_avail)
				free (descr->country_avail);

			descr->country_avail = descr_country_availability (ptr, len);
			break;
		case DESCR_SERVICE: 
			if (descr->service) {
				free (descr->service->provider_name);
				free (descr->service->service_name);
				free (descr->service);
			}

			descr->service = descr_service (ptr, len);
			break;
		case DESCR_BOUQUET_NAME:
		case DESCR_LINKAGE:
		case DESCR_NVOD_REF:
		case DESCR_TIME_SHIFTED_SERVICE:
		case DESCR_MOSAIC:
		case DESCR_CA_IDENT:
		case DESCR_TELEPHONE:
		case DESCR_ML_SERVICE_NAME:
case DESCR_NW_NAME:
		case DESCR_PRIV_DATA_SPEC: {
			int i;
			/*
			fprintf (stderr, "SDT: unhandled descr 0x%x\n", get_descr(ptr));
			for (i=0; i < get_descr_len(ptr); i++) 
				fprintf (stderr, "%c (0x%x) ", *(ptr + i + DESCR_GEN_LEN), *(ptr + i + DESCR_GEN_LEN));
			*/
		}
			break;

		default:
		  //fprintf (stderr, "SDT: invalid descr %s (0x%x)\n", decode_descr (*ptr), get_descr(ptr));
	}

	return 0;
}
