
/*
 * PROGRAM MAP TABLE ROUTINES
 *
 * Copyright (C) 1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as dent@cosy.sbg.ac.at, or
 * Thomas Mirlacher, Jakob-Haringerstr. 2, A-5020 Salzburg,
 * Austria
 *
 *------------------------------------------------------------
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>	//strdup

#include "ca.h"
#include "decode.h"
#include "pmt.h"
#include "descr.h"
#include "dvb.h"
#include "indentifier.h"


extern int debug_flag;


// ISO/IEC 12818-1 P47


static int _parse_pmt_descr(u_char *buf, u_int len, void *dvb_pmt);


int parse_pmt(u_char *buf, dvb_pmt_t *dvb_pmt)
{
int i;
struct pmt_struct* pmt = (struct pmt_struct*) buf;
u_int sec_len;
int info_len = 0;
int stream_len;
u_char *ptr = buf;
int tmp_info_len;
int last_section_number, section_number;

if(debug_flag)
	{
	fprintf(stdout,\
	"parse_pmt(): arg buf=%lu dvb_pmt=%lu\n",\
	buf, dvb_pmt);
	}

if(pmt->table_id != TID_PMT)
	{
	fprintf (stderr, "PMT: wrong TID %x\n", pmt->table_id);
	return -1;
	}

sec_len = HILO (pmt->section_length);
info_len = HILO (pmt->program_info_length);

last_section_number = pmt -> last_section_number;
section_number = pmt -> section_number;

if(debug_flag)
	{
	fprintf(stdout,\
	"parse_pmt(): sec_len=%d info_len=%d\n\
	last_section_number=%d section_number=%d\n",\
	sec_len, info_len,\
	last_section_number, section_number);
	}

if(debug_flag)
	{
	fprintf(stdout, "parse_pmt(): buffer for this length reads:\n");
	for(i = 0; i < sec_len; i++)
		{
		fprintf(stdout, "buf[%d]=%d\n", i, buf[i]);	
		}
	fprintf(stdout, "\n");
	}

if (sec_len < info_len + PMT_LEN)
	{
	fprintf(stdout,\
	"parse_pmt(): sec_len < info_len + PMT_LEN returning\n");
	return -1;
	}

/*
from printing for RAI 1 RAI 2 and RAI 3 added in dvb.c in structure
dvb_pmt_struct default_uadio_pid
*/
dvb_pmt -> default_audio_pid = buf[19];

dvb_pmt->prog_nr = HILO (pmt->program_number);
dvb_pmt->version = pmt->version_number;
dvb_pmt->pcr_pid = HILO (pmt->PCR_PID);

if(debug_flag)
	{
	fprintf(stdout,\
	"parse_pmt(): prog_nr=%d version=%d pcr_pid=%d default_audio_pid=%d\n",\
	dvb_pmt->prog_nr, dvb_pmt->version, dvb_pmt->pcr_pid,\
	dvb_pmt -> default_audio_pid);
	}

ptr += PMT_LEN;	

tmp_info_len = info_len;

while (tmp_info_len > 0)
	{
	_parse_pmt_descr(ptr, info_len, dvb_pmt);

	tmp_info_len -= get_descr_len (ptr) + DESCR_GEN_LEN;

	ptr += get_descr_len (ptr) + DESCR_GEN_LEN;
	}
stream_len = (sec_len - info_len - PMT_LEN);
	
// delete previous entries
if (dvb_pmt->stream)
	{
	struct dvb_pmt_stream_struct *ptr = dvb_pmt->stream;

	do
		{
		struct dvb_pmt_stream_struct *next = ptr->next;
		//if (ptr->info)
		//	free (ptr->info);

		free (ptr);

		ptr = next;
		}
	while (ptr);

	dvb_pmt->stream = NULL;
	}

while(stream_len > 0)
	{
	struct dvb_pmt_stream_struct *stream;
	struct pmt_info_struct* info = (struct pmt_info_struct *) ptr;

	int descr_len;

	if(debug_flag)
		{
		fprintf(stdout,\
		"parse_pmt(): in while stream_len stream_len=%d\n",\
		stream_len);
		}

	// malloc struct entry and hook it into place
	stream = calloc (1, sizeof (struct dvb_pmt_stream_struct));

	if (!dvb_pmt->stream) dvb_pmt->stream = stream;
	else 
		{
		struct dvb_pmt_stream_struct *ptr = dvb_pmt->stream;

		while (ptr->next) ptr = ptr->next;

		ptr->next = stream;
		}

	stream->stream_type = info->stream_type;

	if(debug_flag)
		{
		fprintf(stdout,\
		"parse_pmt(): set stream->type=%d\n", stream->stream_type);
		}

	stream->pid = HILO (info->elementary_PID);
	if(debug_flag)
		{
		fprintf(stdout,\
		"parse_pmt(): set stream->pid=%d\n", stream->pid);
		}

	descr_len = HILO(info->ES_info_length);

	ptr += PMT_info_LEN;

	stream_len -= PMT_info_LEN + get_descr_len (ptr);

	if(debug_flag)
		{
		fprintf(stdout,\
		"parse_pmt():  get_descr_len (ptr)=%d PMT_info_LEN=%d\n\
		new stream_len=%d\n",\
		get_descr_len (ptr), PMT_info_LEN, stream_len);
		}

	while(descr_len > 0)
		{
		if(debug_flag)
			{
			fprintf(stdout,\
			"parse_pmt(): in while descr_len\n");
			}

		_parse_pmt_descr(ptr, descr_len, stream);

		ptr += get_descr_len (ptr) + DESCR_GEN_LEN;
		descr_len -= get_descr_len (ptr) + DESCR_GEN_LEN;
		}
	}

return 0;
}


static int _parse_pmt_descr(u_char *ptr, u_int len, void *dvb_pmt)
{
int a;

if(debug_flag)
	{
	fprintf(stdout,\
	"_parse_pmt_descr(): arg ptr=%lu len=%d dvb_pmt=%lu\n",\
	ptr, len, dvb_pmt); 
	}

a = get_descr(ptr);
if(debug_flag)
	{
	fprintf(stdout,\
	"_parse_pmt_descr(): switch a=% (get_desrcr(ptr) )\n",\
	a);
	}
switch(a)
	{
	case 9:
		{
		if(debug_flag)
			{
			ca_descr_t *cad = (ca_descr_t *) ptr;

			fprintf(stdout, "CA descriptor: len=%02x sysid=%04x pid=%04x\n", 
			cad->descriptor_length, HILO(cad->CA_system_ID),
			HILO(cad->CA_PID) );
			}
		}	

//		fprintf (stdout, "PMT: unhandled descriptor (0x%0x) %s\n",\
//		get_descr(ptr), decode_descr(get_descr(ptr)));
		break;
			
	case DESCR_MOSAIC:
	case DESCR_STREAM_ID:
	case DESCR_TELETEXT:
	case DESCR_SUBTITLING:
	case DESCR_SERVICE_MOVE:
	default:
		//fprintf (stderr, "PMT: unhandled descriptor (0x%0x) %s\n", get_descr(ptr), decode_descr(get_descr(ptr)));
	break;
	}

return 0;
}
