
/*
 * NETWORK INFORMATION TABLE ROUTINES
 *
 * Copyright (C) 1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as dent@cosy.sbg.ac.at, or
 * Thomas Mirlacher, Jakob-Haringerstr. 2, A-5020 Salzburg,
 * Austria
 *
 *------------------------------------------------------------
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#include "nit.h"
//#include <dvb/dvb.h>
#include "descr.h"
#include "dvb.h"

#include "dvb.h"
#include "indentifier.h"

#include "decode.h"

extern int debug_flag;


static int _parse_nit_descr (u_char *buf, dvb_nit_t *dvb_nit);

int parse_nit (u_char *buf, dvb_nit_t *dvb_nit) 
{
/*
if(debug_flag)
	{
	fprintf(stdout,\
	"parse_nit(): arg buf=%lu *dvb_nit=%lu\n",\
	buf, dvb_nit);
	}
*/
nit_t *nit = (nit_t *) buf;
nit_mid_t *nit_mid;
u_char *ptr = buf;
u_int sec_len, descr_len;
int ts_loop_len;

if (nit->table_id != TID_NIT_ACT || nit->table_id != TID_NIT_ACT)
	{
	fprintf (stderr, "NIT: wrong TID %x\n", nit->table_id);
	return -1;
	}

sec_len = HILO (nit->section_length);

if (sec_len < (NIT_LEN)) return -1;

descr_len = HILO (nit->network_descriptor_length);
	
ptr += NIT_LEN;

_parse_nit_descr (ptr, dvb_nit);

ptr += descr_len;

nit_mid = (nit_mid_t *) ptr;
ts_loop_len = HILO (nit_mid->transport_stream_loop_length);
	
ptr += 2;

while (ts_loop_len > 0)
	{
	nit_ts_t *nit_ts = (nit_ts_t *) ptr;
	int ts_descr_len;

	dvb_nit->ts_id = HILO (nit_ts->transport_stream_id);
	dvb_nit->orig_nw_id = HILO (nit_ts->original_network_id);

	ts_descr_len = HILO (nit_ts->transport_descriptors_length);

	ptr += 6; 
	ts_loop_len -= 6 + ts_descr_len;

	while (ts_descr_len > 0)
		{
		_parse_nit_descr (ptr, dvb_nit);

		ts_descr_len -= get_descr_len(ptr) + DESCR_GEN_LEN;
		ptr += get_descr_len(ptr) + DESCR_GEN_LEN;
		}
	}

return 0;
}/* end function parse_nit */


static int _parse_nit_descr (u_char *ptr, dvb_nit_t *dvb_nit)
{
/*
if(debug_flag)
	{
	fprintf(stdout,\
	"_parse_nit_descr(): arg ptr=%lu dvb_nit=%lu\n",\
	ptr, dvb_nit); 
	}
*/
	switch (get_descr (ptr)) {
		case DESCR_NW_NAME: {
			if (dvb_nit->name)	
				free (dvb_nit->name);

			dvb_nit->name = calloc (1, get_descr_len (ptr) + 1);
			memcpy (dvb_nit->name, ptr+DESCR_GEN_LEN, get_descr_len (ptr));
		}
			break;
		case DESCR_STUFFING:
			break;
		case DESCR_SAT_DEL_SYS: {
			struct descr_satellite_delivery_system_struct *descr = (struct descr_satellite_delivery_system_struct *) (ptr + DESCR_GEN_LEN);

			dvb_nit->freq  = 1E2 * ((descr->frequency1 & 0xF0) >> 4);
			dvb_nit->freq += 1E1 * (descr->frequency1 & 0x0F);
			dvb_nit->freq += 1E0 * ((descr->frequency2 & 0xF0) >> 4);
			dvb_nit->freq += 1E-1 * (descr->frequency2 & 0x0F);
			dvb_nit->freq += 1E-2 * ((descr->frequency3 & 0xF0) >> 4);
			dvb_nit->freq += 1E-3 * (descr->frequency3 & 0x0F);
			dvb_nit->freq += 1E-4 * ((descr->frequency4 & 0xF0) >> 4);
			dvb_nit->freq += 1E-5 * (descr->frequency4 & 0x0F);

			dvb_nit->orbit = 1E2 * ((descr->orbital_position1 & 0xF0) >> 4);
			dvb_nit->orbit += 1E1 * (descr->orbital_position1 & 0x0F);
			dvb_nit->orbit += 1E0 * ((descr->orbital_position2 & 0xF0) >> 4);
			dvb_nit->orbit += 1E-1 * (descr->orbital_position2 & 0x0F);

			dvb_nit->west_east = descr->west_east_flag;

			dvb_nit->rate = 1E2 * (int) ((descr->symbol_rate1 & 0xF0) >> 4);
			dvb_nit->rate += 1E1 * (int) (descr->symbol_rate1 & 0x0F);
			dvb_nit->rate += 1E0 * (int) ((descr->symbol_rate2 & 0xF0) >> 4);
			dvb_nit->rate += 1E-1 * (int) (descr->symbol_rate2 & 0x0F);
			dvb_nit->rate += 1E-2 * (int) ((descr->symbol_rate3 & 0xF0) >> 4);
			dvb_nit->rate += 1E-3 * (int) (descr->symbol_rate3 & 0x0F);
			dvb_nit->rate += 1E-4 * (int) (descr->symbol_rate4 & 0x0F);

			dvb_nit->fec = descr->fec_inner;
		}
			break;
		case DESCR_SERVICE_LIST:
		        break;
        	case DESCR_CABLE_DEL_SYS: {
			struct descr_cable_delivery_system_struct *descr = 
			  (struct descr_cable_delivery_system_struct *)
			  (ptr + DESCR_GEN_LEN);

			dvb_nit->freq  = 1E3 * ((descr->frequency1 & 0xF0) >> 4);
			dvb_nit->freq += 1E2 * (descr->frequency1 & 0x0F);
			dvb_nit->freq += 1E1 * ((descr->frequency2 & 0xF0) >> 4);
			dvb_nit->freq += 1E0 * (descr->frequency2 & 0x0F);
			dvb_nit->freq += 1E-1 * ((descr->frequency3 & 0xF0) >> 4);
			dvb_nit->freq += 1E-2 * (descr->frequency3 & 0x0F);
			dvb_nit->freq += 1E-3 * ((descr->frequency4 & 0xF0) >> 4);
			dvb_nit->freq += 1E-4 * (descr->frequency4 & 0x0F);

			dvb_nit->qam = descr->modulation;

			dvb_nit->rate = 1E2 * (int) ((descr->symbol_rate1 & 0xF0) >> 4);
			dvb_nit->rate += 1E1 * (int) (descr->symbol_rate1 & 0x0F);
			dvb_nit->rate += 1E0 * (int) ((descr->symbol_rate2 & 0xF0) >> 4);
			dvb_nit->rate += 1E-1 * (int) (descr->symbol_rate2 & 0x0F);
			dvb_nit->rate += 1E-2 * (int) ((descr->symbol_rate3 & 0xF0) >> 4);
			dvb_nit->rate += 1E-3 * (int) (descr->symbol_rate3 & 0x0F);
			dvb_nit->rate += 1E-4 * (int) (descr->symbol_rate4 & 0x0F);

			dvb_nit->fec = descr->fec_inner;
		}
			break;
		case DESCR_LINKAGE:
		case DESCR_TERR_DEL_SYS:
		case DESCR_ML_NW_NAME:
		case DESCR_PRIV_DATA_SPEC:
			//fprintf (stderr, "NIT: UNCRITICAL unhandled descr (0x%x) %s\n, *ptr, decode_descr (*ptr));
			break;
		default:
			//fprintf (stderr, "NIT: CRITICAL unallowed descr (0x%x) %s\n, *ptr, decode_descr (*ptr));
	}

	return 0;
}
