
/*
 * EVENT INFORMATION TABLE ROUTINES
 *
 * Copyright (C) 2000 Ralph Metzler
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */


#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#include <dvb/eit.h>
#include <dvb/dvb.h>
#include <dvb/descr.h>
#include "dvb.h"

#include "decode.h"

int parse_eit(u_char *buf, dvb_eit_t *dvb_eit) 
{
	eit_t *eit = (eit_t *) buf;
	u_int sec_len;
	u_char *ptr = buf;
		
	if (eit->table_id < TID_EIT_ACT ||
	    eit->table_id >= TID_TDT ) {
		fprintf (stderr, "EIT: wrong TID %x\n", eit->table_id);
		return -1;
	}

	sec_len = HILO (eit->section_length);

	ptr += EIT_SIZE;
	
	while ((ptr - buf + 1) < sec_len) {
	        dvb_eit_event_t *event = calloc (1, sizeof(dvb_eit_event_t));
		eit_event_t *eit_event = (eit_event_t *) ptr;
		
		

		
	}

	return 0;
}

