
/*
 * SECTION PARSING ROUNTINES
 *
 * Copyright (C) 1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as dent@cosy.sbg.ac.at, or
 * Thomas Mirlacher, Jakob-Haringerstr. 2, A-5020 Salzburg,
 * Austria
 *
 *------------------------------------------------------------
 *
 * $log$
 */


#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>

#include "ts.h"
#include "dvb.h"

#include "crc32.h"

int len=0;
u_int sec_len=0;
char cc;

// FIXME: when having PID lookup table, change _buf to buf and store values
//	in lookup table

char *filter_section (u_char *_ts, u_char *buf, u_int pid)
{
	u_char *ptr = _ts;
	ts_hdr_t *ts = (ts_hdr_t *) _ts;

//FIXME: just for reset reasons
	if (buf == NULL) {
		len = 0;
		sec_len = 0;
		return NULL;
	}

/***** do TS stuff *****/
// check SYNC byte
	if (ts->sync_byte != TS_SYNC_BYTE) {
		return NULL;
	}

// filter PID
	if (pid != HILO (ts->PID)) 
		return NULL;

// check Continuity Counter
	if (ts->payload_unit_start_indicator) {
		cc = ts->continuity_counter;
	} else {
		cc++;
		cc %= 0x10;

		if (cc != ts->continuity_counter)  {
			fprintf (stderr, "SEC: NP exp:%x rec:%x\n", cc, ts->continuity_counter);
			len = 0;
		}

		cc = ts->continuity_counter;
	}

/***** do Section stuff *****/

// invalid somewhere in the middle
	if (!ts->payload_unit_start_indicator && !len) {
		sec_len = 0;
		len = 0;
		fprintf (stderr, "SEC: ERR in the middle\n");
		return NULL;
	}

	ptr += TS_HDR_LEN;			// skip TS hdr

	if (ts->adaptation_field_control & 0x02)// has AF
		ptr += 1 + buf[TS_HDR_LEN];	// skip AF_len + AF

	if ((ptr-_ts) >= TS_LEN) {
		sec_len = 0;
		len = 0;
		fprintf (stderr, "SEC: ERR len1\n");
		return NULL;
	}

	if (ts->payload_unit_start_indicator) {
		if ((ptr + *ptr +1) > (_ts + TS_LEN)) {
			sec_len = 0;
			len = 0;
			fprintf (stderr, "SEC: ERR len2 %x\n", *ptr);
			return NULL;
		}

		ptr += *ptr + 1;		// skip section ptr field

		sec_len = (*(ptr+1) & 0x0F) << 8 | (*(ptr+2) & 0xFF);
		len = 0;
	}

	memcpy (buf+len, ptr, TS_LEN - (ptr-_ts));
#if 0
{ int i;
for (i=0; i<(TS_LEN - (ptr-_ts)); i++)
	if (isprint (ptr[i])) {
		fprintf (stderr, "%c  ", ptr[i]);
	} else {
		fprintf (stderr, "%02x ", ptr[i]);
	}

fprintf (stderr, "\n\n");
}
#endif

	len += TS_LEN - (ptr-_ts);

	if (len >= sec_len) {
fprintf (stderr, "SEC: completed section 0x%x on PID: 0x%x len: %d\n", *buf, pid, sec_len);
		len = 0;
		return buf;
	}

	return NULL;

#if 0
// crc stuff
{
	int sec_len;
	u_long crc_new;
	u_long crc_orig;

	sec_len = ((*(buf+1) & 0x0F) << 8) | *(buf+2);

	crc_orig = buf[sec_len+2];
	crc_orig = crc_orig << 8 | buf[sec_len+1];
	crc_orig = crc_orig << 8 | buf[sec_len];
	crc_orig = crc_orig << 8 | buf[sec_len-1];
	fprintf (stderr, "crc_orig: %x\n", crc_orig);

	crc_new = crc32 (buf, sec_len);
	fprintf (stderr, "crc: %x\n", crc_new);
}
#endif
}
