/*
tuning program for the Technotrend DVB-s PCI card.
uses /root/channels.conf

Copyright (C) 2000  Jan Mourer
	jan@panteltje.demon.nl

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <unistd.h>
#include <pwd.h>

#include "pscan.h"

#include "dvb.h"
#include "indentifier.h"

#include <pthread.h>
#include <sys/poll.h>


/*
Include the gtk+ header files
Include stdio.h, we need that for the printf() function
*/
#include        <gtk/gtk.h>
#include        <stdio.h>

/*
This is our data identification string to store
data in list items
*/
const gchar *list_item_data_key = "list_item_data";

/*
prototypes for signal handler that we are going to connect
to the GtkList widget
*/
static void  sigh_print_selection( GtkWidget *gtklist,
                                   gpointer   func_data);

static void  sigh_button_event( GtkWidget      *gtklist,
                                GdkEventButton *event,
                                GtkWidget      *frame );


#define ASTRA_START			11798
#define ASTRA_END			12750
#define ASTRA_STEP			5
#define ASTRA_SYMBOL_RATE	22000

#define HOTBIRD_START		10700
#define HOTBIRD_END			12570
/*
looked up hotbird 1
minimum spacings are (half shift opposite polarity):
(spacing 1(41.5), 2(38.42), 3(38), 4(38.36)
*/
#define HOTBIRD_STEP		15 
#define HOTBIRD_SYMBOL_RATE	27500


#define NO_SCAN			0
#define ASTRA_SCAN		1
#define HOTBIRD_SCAN	2
#define MAN_SCAN		3

int debug_flag;
int symbolrate;
char polarization;
int frequency;
int sat_scan_mode;
char *home_dir;
int start_frequency;
int end_frequency;
int frequency_step;
int video_device;
int diseqc;

#define MAXDVBAPI 10
#define VIDEODEV "/dev/video"

/* proto types */
int show_tv_toggle( GtkWidget *widget, gpointer callback_data);


char *strsave(char *s) /* save char array s somewhere */
{
char *p;

/* argument check */
if(! s) return 0;

p = malloc(strlen(s) +  1);
if(p) strcpy(p, s);
return(p);
}/* end function strsave */

int SetChannel(int videoDev,\
	int FrequencyMHz, char Polarization, int Diseqc, int Srate,\
	int Vpid, int Apid, int Tpid, int Ca, int Pnr)
{
unsigned int freq;

if(debug_flag)
	{
	fprintf(stdout,\
	"SetChannel(): arg\n\
	FrequencyMHz=%d Polarization=%c Diseqc=%d Srate=%d\n\
	Vpid=%d Apid=%d Tpid=%d Ca=%d Pnr=%d\n",\
	FrequencyMHz, Polarization, Diseqc, Srate,\
	Vpid, Apid, Tpid, Ca, Pnr);
	}

if (videoDev >= 0)
	{
	struct frontend front;
	ioctl(videoDev, VIDIOCGFRONTEND, &front);

	freq = FrequencyMHz;
	front.ttk = (freq < 11700UL) ? 0 : 1;
	if (freq < 11700UL) freq -=  9750UL;
	else freq -= 10600UL;
	front.channel_flags = Ca ? DVB_CHANNEL_CA : DVB_CHANNEL_FTA;
	front.pnr       = Pnr;
	front.freq      = freq * 1000000UL;
	front.diseqc    = Diseqc;
	front.srate     = Srate * 1000;
	front.volt      = (Polarization == 'v' || Polarization == 'V') ? 0 : 1;
	front.video_pid = Vpid;
	front.audio_pid = Apid;
	front.tt_pid	= Tpid;
	front.fec       = 8;
	front.AFC       = 1;
	front.channel_flags = DVB_CHANNEL_FTA; /* (0) else DVB_CHANNEL_CA (1) */

	ioctl(videoDev, VIDIOCSFRONTEND, &front);

	if (front.sync & 0x1F == 0x1F)
		{
//		fprintf(stdout, "SetChannel(): set\n");

        return 1;
		}

//	esyslog(LOG_ERR,\
//	"ERROR: channel not sync'ed (front.sync=%X)!", front.sync);

//	fprintf(stdout,\
//	"channel not sync'ed (front.sync=%X)!\n",\
//	front.sync);
	}

return 0;
}/* end function SetChannel */


/* Main function to set up the user interface */
gint main(int argc, gchar *argv[])
{                                  
guint i;
gchar buffer[65535];
GtkWidget *separator;
GtkWidget *window;
GtkWidget *vbox;
GtkWidget *scrolled_window;
GtkWidget *frame;
GtkWidget *gtklist;
GtkWidget *button;
GtkWidget *list_item;
GList *dlist;

int a, f, r;
struct video_capability cap;
char temp[1024];
char *station;
int vpid;
int apid;
int tpid;
int ca;
int pnr;
int selected_channel;
char channel_name[100];
char temp2[100];
struct passwd *userinfo;
int man_flag;
char tin1[80], tin2[80], tin3[80], tin4[80], tin5[80], tin6[80], tin7[80];
FILE *fptr;
char *entry_name;
int connected;

/*select con io 1 byte at the time*/
setbuf(stdout,NULL);
setbuf(stdin,NULL);

iopl(3);

#ifdef PCTV1000
tv1000_ini();
#endif

while(1)
	{
	a = getopt(argc, argv, "d");
	if(a == -1) break;
	switch(a)
		{
//        case 'c':
//       	sscanf(optarg, "%500s", channel_name);
//        	break;
        case 'd': /* not to conflict with -d display option for x */
			debug_flag = 1;
			break;
		case 'h':
			fprintf(stdout,\
"Usage:\n\
pview [-d] [-h]
\t-d  send debug output to console\n\
\t-h  help (this help).\n\
");
			exit(0);	
			break;
		case '?':
			if (isprint(optopt) )
 				{
 				fprintf(stdout, "Unknown option `-%c'.\n", optopt);
 				}
			else
				{
				fprintf(stdout, "Unknown option character `\\x%x'.\n",\
				optopt);
				}
			exit(1);
			break;			
		default:
			break;
		}/* end switch a */
	}/* end while getopt() */

fprintf(stdout, "\nPanteltje pview-%s\n\n", PVIEW_VERSION);

userinfo = getpwuid(getuid() );
if(! userinfo)
	{
	fprintf(stdout, "could not get userinfo\n");
	exit(1);
	}

/* get home directory */ 
home_dir = strsave(userinfo -> pw_dir);
if(! home_dir)
	{
	fprintf(stdout, "could not allocate space for home_dir\n");
	exit(1);
	}

/* Initialize gtk+ (and subsequently gdk) */
gtk_init(&argc, &argv);

/*
Create a window to put all the widgets in
the window to handle window manager close-window-events
*/
window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
gtk_window_set_title(GTK_WINDOW(window), "pview");

/* connect gtk_main_quit() to the "destroy" event of */
gtk_signal_connect(GTK_OBJECT(window),
	"destroy",
	GTK_SIGNAL_FUNC(gtk_main_quit),
	NULL);

/*
Inside the window we need a box to arrange the widgets
vertically
*/
vbox = gtk_vbox_new(FALSE, 5);
gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);
gtk_container_add(GTK_CONTAINER(window), vbox);
gtk_widget_show(vbox);
    
/* This is the scrolled window to put the GtkList widget inside */
scrolled_window = gtk_scrolled_window_new(NULL, NULL);

gtk_widget_set_usize(scrolled_window, 350, 500);/* was 250, 160 */
gtk_container_add(GTK_CONTAINER(vbox), scrolled_window);
gtk_widget_show(scrolled_window);
    
/*
Create the GtkList widget.
Connect the sigh_print_selection() signal handler
function to the "selection_changed" signal of the GtkList
to print out the selected items each time the selection
has changed
*/
gtklist = gtk_list_new();
gtk_scrolled_window_add_with_viewport( GTK_SCROLLED_WINDOW(scrolled_window),
                                           gtklist);
gtk_widget_show(gtklist);
gtk_signal_connect(GTK_OBJECT(gtklist),
	"selection_changed",
	GTK_SIGNAL_FUNC(sigh_print_selection),
	NULL);
    
/*
Connect the sigh_button_event() signal handler to the GtkList
which will handle the "arresting" of list items
*/
gtk_signal_connect(GTK_OBJECT(gtklist),
	"button_release_event",
	GTK_SIGNAL_FUNC(sigh_button_event),
	frame);
    
/* Create a separator */
separator = gtk_hseparator_new();
gtk_container_add(GTK_CONTAINER(vbox), separator);
gtk_widget_show(separator);
    

#ifdef PCTV1000
/*
Finally create a button and connect it's "clicked" signal
to the destruction of the window
*/
button = gtk_button_new_with_label("TV / Computer");
gtk_container_add(GTK_CONTAINER(vbox), button);
gtk_widget_show(button);
/*
gtk_signal_connect_object(GTK_OBJECT(button),
	"clicked",
	GTK_SIGNAL_FUNC(gtk_widget_destroy),
	GTK_OBJECT(window));
*/
gtk_signal_connect_object(GTK_OBJECT(button),
	"clicked",
	(GtkSignalFunc)show_tv_toggle, NULL); //	argument GTK_OBJECT(window) );
#endif
   
/* connect to dvb driver */
connected = 0;
for(i = 0; i < 10; i++)
	{
	sprintf(temp, "%s%d", VIDEODEV, i);
	if(access(temp, F_OK | R_OK | W_OK) != 0)
		{
		fprintf(stdout, "main(): could not access device %s\n", temp);
		perror("access");
//		exit(1);
		}

	video_device = open(temp, O_RDWR);
	if(video_device < 0) 
		{
		fprintf(stdout,\
		"main(): could not open device %s for read_write\n", temp);
//		exit(1);		
		}

	r = ioctl(video_device, VIDIOCGCAP, &cap);

	if(debug_flag)
		{
		fprintf(stdout, "r=%d dev=%s\n", r, temp);
		}

	if(r == 0 && (cap.type & VID_TYPE_DVB) )
//	if(r == 0 && (cap.type & VID_TYPE_TELETEXT) )
		{
		fprintf(stdout, "connected to %s\n", temp);
		connected = 1;
		break;

		/* close video device */
		close(video_device);
		}/* end if f OK */
	else
		{
//		fprintf(stdout, "BAD %s\n", temp);
		}

	}/* end for i */

if(! connected) exit(1);

sprintf(temp, "%s/channels.conf", home_dir);

/*
if(! load_programs_vdr_format(temp) )
	{
	
	exit(1);
	}

load_program_list(buffer, list_item_data_key, gtklist);
*/

fptr = fopen(temp, "r");
if(! fptr)
	{
	fprintf(stdout, "Could not open file %s for read\n", temp);
	exit(1);
	}

dlist = NULL;

while(1)
	{
	GtkWidget       *label;
	gchar           *string;
	
	a = readline(fptr, buffer); /* closes file on EOF */
	if(a == EOF) break;

	label = gtk_label_new(buffer);

	gtk_misc_set_alignment (GTK_MISC (label), 0, 0);

	list_item = gtk_list_item_new();/* centers display */

	gtk_container_add(GTK_CONTAINER(list_item), label);

	gtk_widget_show(label);

	gtk_container_add(GTK_CONTAINER(gtklist), list_item);

	gtk_widget_show(list_item);

	gtk_label_get(GTK_LABEL(label), &string);

	gtk_object_set_data(GTK_OBJECT(list_item),
		list_item_data_key,
		string);
	}

gtk_list_append_items(GTK_LIST(gtklist), dlist);
    
/* show window */
gtk_widget_show(window);
    
/* Fire up the main event loop of gtk */
gtk_main();
    
return(0);
}/* end function main */


/*
This is the signal handler that got connected to button
press / release events of the GtkList
*/
void sigh_button_event( GtkWidget      *gtklist,
                        GdkEventButton *event,
                        GtkWidget      *frame )
{

/*
We only do something if the third (rightmost mouse button)
was released
*/
if (event->type == GDK_BUTTON_RELEASE && event->button == 3)
	{
	GList           *dlist, *free_list;
	GtkWidget       *item;
	
	/*
	Fetch the currently selected list
	*/
	dlist = GTK_LIST(gtklist)->selection;
	if (dlist) item = GTK_WIDGET(dlist->data);
	else item = NULL;
	
    }
}/* end function sigh_button_event */


/*
This is the signal handler that gets called if GtkList
emits the "selection_changed" signal
*/
void sigh_print_selection( GtkWidget *gtklist, gpointer   func_data)
{
GList   *dlist;
char *station;
int frequency, polarization, diseqc;
int	symbolrate, vpid, apid, tpid, ca, pnr;

/*
Fetch the doubly linked list of selected items
of the GtkList, remember to treat this as read-only!
*/
dlist = GTK_LIST(gtklist)->selection;
    
/*
If there are no selected items there is nothing more
to do than just telling the user so
*/
if(!dlist)
	{
//	g_print("Selection cleared\n");
	return;
    }
/*
Ok, we got a selection and so we print it
*/
//g_print("The selection is a ");
    
/*
Get the list item from the doubly linked list
and then query the data associated with list_item_data_key.
We then just print it
*/
while (dlist)
	{
	GtkObject       *list_item;
	gchar           *item_data_string;
	
	list_item = GTK_OBJECT(dlist->data);
	item_data_string = gtk_object_get_data(list_item, list_item_data_key);

//	g_print("%s ", item_data_string);
	
	if(debug_flag)
		{
		fprintf(stdout, "WAS detected=%s\n", item_data_string);		
		}

	/* parse item_data_string here and do a SetChannel */
	sscanf(item_data_string,\
	"%a[^:]:%d:%c:%d:%d:%d:%d:%d:%d:%d",\
	station, &frequency, &polarization, &diseqc,\
	&symbolrate, &vpid, &apid, &tpid, &ca, &pnr);

	SetChannel(\
		video_device,		//videoDev
		frequency,			//FrequencyMHz
		polarization,		//char Polarization
		diseqc,				//int Diseqc
		symbolrate,			//int Srate
		vpid,				//int Vpid
		apid,				//int Apid
		tpid,				//int Tpid
		ca,					//int Ca 
		pnr					//int Pnr
		);

//	print_signal_strength(f);

	dlist = dlist->next;
    }
g_print("\n");
}/* end function sigh_print_selection */


int show_tv_toggle( GtkWidget *widget, gpointer callback_data)
{
static int screen_mode;

if(debug_flag)
	{
	fprintf(stdout, "show_tv_toggle(): arg\n");
	}

screen_mode = 1 - screen_mode;
tv1000_set_screen(screen_mode);

return 1;
}/* end function show_tv_toggle */


