#include <stdio.h>

#include "ts.h"
#include "dvb.h"
#include "tbl.h"
#include "sections.h"
#include "decode.h"

extern int debug_flag;
extern int symbolrate;
extern char polarization;
extern int frequency;

/* proto types  */
extern int add_service(
	char *name,\
	char *service_name,\
	int transponder_id,\
	int orig_nw_id,\
	float orbit,\
	char west_east,\
	char *country_avail,\
	char *service_type,\
	int symbolrate,\
	char *fec,\
	char *provider,\
	int version,\
	int frequency,\
	char polarization,\
	int disecq,\
	int cpid,\
	int vpid,\
	int apid,\
	int tpid,\
	int ca,\
	int apnr);


int print_all(\
dvb_pat_t *dvb_pat, dvb_sdt_t *dvb_sdt, int *transponder_frequency)
{
int a;
dvb_pat_prog_t *prog;
char temp[4096];
char service_name[4096];
int transponder_id;
int orig_nw_id;
float orbit;
int west_east;
char country_avail[4096];
char service_type[4096];
char fec[1024];
char provider[1024];
int version;
//int transponder_frequency;
int transponder_symbolrate;
int disecq;
int cpid;
int vpid;
int apid;
int tpid;
int pcr_pid;
int prog_pid;
int ca;
int pnr;
int passes;
//Channel chan;

if(debug_flag)
	{
	fprintf(stdout, "_print_all(): arg dvb_pat=%lu dvb_sdt=%lu\n",\
	dvb_pat, dvb_sdt);
	}

/*
use scanning frequency,
if we get a transponder frequency we overrule this.
*/
*transponder_frequency = frequency;
transponder_symbolrate = symbolrate;

printf ("TS_ID: %d Version: %d\n", dvb_pat->ts_id, dvb_pat->version);

transponder_id = dvb_pat->ts_id;
version = dvb_pat->version;

prog = dvb_pat->prog;
while(prog)
	{
	printf ("\tProg_Nr: %d PID: %d\n", prog->prog_nr, prog->pid);

	pnr = prog->prog_nr;
	prog_pid = prog->pid;

	/* test if prognr */
	if (!prog->prog_nr)/* program zero */
		{

		/* test for NIT */
		if (!prog->prog.nit) /* no NIT */
			{
			printf ("\t\tNo details.\n");
			}
		else /* have NIT */
			{
			printf ("\t\tts_id: %d\n", prog->prog.nit->ts_id);
			transponder_id = prog->prog.nit->ts_id;

			printf ("\t\torig_nw_id: %d\n", prog->prog.nit->orig_nw_id);
			orig_nw_id = prog->prog.nit->orig_nw_id;
			
			printf ("\t\tname: %s\n", prog->prog.nit->name);
			sprintf(service_name, "%s", prog->prog.nit->name);

			printf ("\t\tfreq: %f\n", prog->prog.nit->freq);

			if( (1000 * prog->prog.nit->freq) != 0)
				{
				*transponder_frequency =  1000 * prog->prog.nit->freq;
				}

			printf ("\t\torb: %f\n", prog->prog.nit->orbit);
			orbit = prog->prog.nit->orbit;

			printf ("\t\twest_east: %c\n",\
			prog->prog.nit->west_east ? 'E' : 'W');
			west_east = prog->prog.nit->west_east ? 'E' : 'W';

			printf ("\t\trate: %f\n", prog->prog.nit->rate);
//			transponder_symbolrate = 1000 * prog->prog.nit->rate;

			printf ("\t\tfec: %s\n", decode_fec (prog->prog.nit->fec));
			sprintf(fec, "%s", decode_fec (prog->prog.nit->fec) );

			} /* end if have NIT */
		// modulation, polarization
		}/* end if prognr = 0 */
	else /* prog_nr != 0 */
		{

		/* test for PMT */
		dvb_pmt_stream_t *stream;

		if (!prog->prog.pmt) /* if no PMT */
			{
			printf ("\t\tNo details.\n");
			}
		else /* have PMT */
			{
			stream = prog->prog.pmt->stream;
			printf ("\t\tprog_nr: %d\n", prog->prog.pmt->prog_nr);

			// SDT
			if (dvb_sdt && dvb_sdt->service)
				{
				dvb_sdt_service_t *service = dvb_sdt->service;

				while(service)
					{
					if (prog->prog.pmt->prog_nr == service->service_id)
						{
						if (service->descr && service->descr->service)
							{
							printf ("\t\tprovider: %s\n",\
							service->descr->service->provider_name);
							sprintf(provider, "%s",\
							service->descr->service->provider_name);
 
							printf ("\t\tservice: %s\n",\
							service->descr->service->service_name);
							sprintf(service_name, "%s",\
							service->descr->service->service_name);

							}
						}		

					service = service->next;
					}
				}/* end while service */

			printf ("\t\tversion: %d\n", prog->prog.pmt->version);
			version = prog->prog.pmt->version;

			printf ("\t\tpcr PID: %d\n", prog->prog.pmt->pcr_pid);

//			pcr_pid = prog->prog.pmt->pcr_pid;
			
			/* normally pcr PID, else overruled */
			vpid = prog->prog.pmt->pcr_pid;

			/*
			seems to be at pmt + 19 as a single byte
			this can also be 11 or 1 (control channel?)
			*/
			apid = prog->prog.pmt->default_audio_pid;
			tpid = 0;
			if(debug_flag)
				{
				fprintf(stdout,\
				"print_all(): pcr_pid=%d default_audio_pid=%d\n",\
				pcr_pid, apid);
				}

			passes = 0;
			while(stream)
				{
				printf ("\t\t\tpid: %d\n", stream->pid);

				printf ("\t\t\ttype: (%d) %s\n",\
				stream->stream_type,\
				decode_stream_type (stream->stream_type) );

				switch(stream -> stream_type)
					{
					case 0: /* ITU-T|ISO/IEC Reserved */
						break;
					case 1: /* ISO/IEC Video */
						vpid = stream -> pid;
						break;
					case 2: /* 13818-2 Video or 11172-2 constrained V */
						vpid = stream -> pid;
						break;
					case 3: /* ISO/IEC 11172 Audio */
						apid = stream -> pid;
						break;
					case 4: /* ISO/IEC 13818-3 Audio */
						apid = stream -> pid;
						break;
					case 5: /* private_sections */
						break;
					case 6: /* packets containing private data */
						tpid = stream->pid;
						break;
					case 7: /* ISO/IEC 13522 MPEG */
//						vpid = stream -> pid;								
						break;
					case 8:   /* ITU-T Rec. H.222.1 */
						break;
					case 9:  /* ISO/IEC 13818-6 type A */
						break;
					case 10: /* ISO/IEC 13818-6 type B */
						break;
					case 11: /* ISO/IEC 13818-6 type C */
						break;
					case 12: /* ISO/IEC 13818-6 type D */
						break;
					case 13: /* ISO/IEC 13818-1 auxiliary */
						break;
					case 14: /* ITU-T Rec. H.222.0 | ISO 13818-1 Reserved */
						break;
					case 15: /* User private */
						break;
					case 0xc55: /* private sections */
						break;
					case 0x42: /*ITU-T Rec. H.222.0 | ISO 13818-1 Reserved*/
						break;
					default:
						break;
					}/* end switch type */
				stream = stream -> next;
				passes++;

				/* test for no data */
				if( (vpid == 0) && (apid == 0) && (tpid == 0) ) continue;

				/* test for control channel */
				if(apid <= 11)  continue;

				/* make unique indentifier */
//				sprintf(temp, "%d:%d:%d:%d:%d",\
//				transponder_id, pnr, prog_pid, vpid, apid);

				/* VDR format */
				sprintf(temp, "%s:%d:%c:%d:%d:%d:%d:%d:%d\n",\
				service_name, *transponder_frequency, polarization,\
				disecq, symbolrate, vpid, apid,\
				ca, pnr);

				if(! add_service(\
				temp, service_name, transponder_id, orig_nw_id, orbit,\
				west_east, country_avail, service_type,\
				transponder_symbolrate, fec, provider, version,\
				*transponder_frequency, polarization, disecq,\
				cpid, vpid, apid, tpid, ca, pnr) )
					{
					return 0;
					}

				}/* end while stream */

			}/* end if have PMT */
		}/* end if have prognr */

	prog = prog -> next;
	}/* end while prog */

return 1;
}/* end function _print_all */


