/*
 * FREE SI STRUCTURES
 *
 * Copyright (C) 2000 Ralph Metzler
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

#include "dvb.h"

/* NOTE: These only free the sub-structures of the structs, 
         not the struct itself */

void free_nit (dvb_nit_t *dvb_nit) 
{
        if (!dvb_nit)
	        return;
        if (dvb_nit->name)
	        free(dvb_nit->name);
}


void free_pat(dvb_pat_t *dvb_pat) 
{
	dvb_pat_prog_t *prog, *next_prog;

        if (!dvb_pat)
	        return;

	prog=dvb_pat->prog;

	while(prog) {
	        if (!prog->prog_nr) {
		        free_nit(prog->prog.nit);
		} else {
		        dvb_pmt_stream_t *stream, *next_stream;
			
			if (prog->prog.pmt) {
			        stream = prog->prog.pmt->stream;
								
				while (stream) {
					next_stream=stream->next;
				        free(stream);
					stream=next_stream;
				}
			}
			
		}
		next_prog=prog->next;
		free(prog);
		prog=next_prog;
	}
}

void free_sdt(dvb_sdt_t *dvb_sdt) 
{
        dvb_sdt_service_t *service, *next_service;

        if (!dvb_sdt)
	        return;

	service = dvb_sdt->service;

	while (service) {
      	        if (service->descr) {
		        if (service->descr->service) {
			        free(service->descr->service->provider_name);
			        free(service->descr->service->service_name);
				free(service->descr->service);
			}
		        free(service->descr);
		}
 	        next_service=service->next;
		free(service);
		service=next_service;
	}
	
}
