#ifndef _DVB_V4L_H_
#define _DVB_V4L_H_

#ifdef __KERNEL__
#include "linux/socket.h" 
#include "linux/netdevice.h" 
#include "linux/in.h" 
#else
#include <netinet/in.h>
#endif

#ifdef V4L2
#include "videodev2.h"
#else
#include "videodev.h"
#endif

/* frontend struct, should move to videodev.h at some time */

struct frontend {
	int type;              /* type of frontend (tv tuner, dvb tuner/decoder, etc. */
#define FRONT_TV   0
#define FRONT_DVBS 1
#define FRONT_DVBC 2
#define FRONT_DVBT 3

	/* Sat line control */
        int power;             /* LNB power 0=off/pass through, 1=on */
	int volt;              /* 14/18V (V=0/H=1) */
	int ttk;               /* 22KHz */
	int diseqc;            /* Diseqc input select */
        

	/* cable line control */



	/* signal decoding, transponder info */

	__u32 freq;            /* offset frequency (from local oscillator) in Hz */
        int AFC;
	__u32 srate;           /* Symbol rate in Hz */
	int qam;               /* QAM mode for cable decoder, sat is always QPSK */
        int inv;               /* Inversion */
	int fec;               /* Forward Error Correction */

        /* channel info */
	__u16 video_pid;        
	__u16 audio_pid;
        __u16 tt_pid;          /* Teletext PID */
        __u16 pnr;             /* Program number = Service ID */
        int channel_flags;             
#define DVB_CHANNEL_FTA        0
#define DVB_CHANNEL_CA         1


	/* status information */

	int fsync;             /* frequency sync (from tuner) */
        __u32 curfreq;         /* frequency which is actually used, e.g. after AFC */

	int sync;              /* sync from decoder */
#define DVB_SYNC_SIGNAL        1
#define DVB_SYNC_CARRIER       2
#define DVB_SYNC_VITERBI       4
#define DVB_SYNC_FSYNC         8
#define DVB_SYNC_FRONT        16
	__s32 afc;               /* frequency offset in Hz */
	__u16 agc;             /* gain */
	__u16 nest;            /* noise estimation */
        __u32 vber;            /* viterbi bit error rate */

	int flags;
#define FRONT_TP_CHANGED  1 
#define FRONT_FREQ_CHANGED 2
#define FRONT_RATE_CHANGED 4
};


struct bitfilter {
        __u16 pid;
        __u16 data[16];
        __u16 mode;
        __u16 handle;
        __u16 flags;
#define FILTER_UDP   1     /* write data to UDP socket */
#define FILTER_MEM   2     /* write data to memory buffer */
        struct in_addr dest;
};

typedef enum {
  // All functions return -2 on "not open"
  OSD_Close=1,    // ()
  // Disables OSD and releases the buffers
  // returns 0 on success
  OSD_Open,       // (x0,y0,x1,y1,BitPerPixel[2/4/8](color&0x0F),mix[0..15](color&0xF0))
  // Opens OSD with this size and bit depth
  // returns 0 on success, -1 on DRAM allocation error, -2 on "already open"
  OSD_Show,       // ()
  // enables OSD mode
  // returns 0 on success
  OSD_Hide,       // ()
  // disables OSD mode
  // returns 0 on success
  OSD_Clear,      // ()
  // Sets all pixel to color 0
  // returns 0 on success
  OSD_Fill,       // (color)
  // Sets all pixel to color <col>
  // returns 0 on success
  OSD_SetColor,   // (color,R{x0},G{y0},B{x1},opacity{y1})
  // set palette entry <num> to <r,g,b>, <mix> and <trans> apply
  // R,G,B: 0..255
  // R=Red, G=Green, B=Blue
  // opacity=0:      pixel opacity 0% (only video pixel shows)
  // opacity=1..254: pixel opacity as specified in header
  // opacity=255:    pixel opacity 100% (only OSD pixel shows)
  // returns 0 on success, -1 on error
  OSD_SetPalette, // (firstcolor{color},lastcolor{x0},data)
  // Set a number of entries in the palette
  // sets the entries "firstcolor" through "lastcolor" from the array "data"
  // data has 4 byte for each color:
  // R,G,B, and a opacity value: 0->transparent, 1..254->mix, 255->pixel
  OSD_SetTrans,   // (transparency{color})
  // Sets transparency of mixed pixel (0..15)
  // returns 0 on success
  OSD_SetPixel,   // (x0,y0,color)
  // sets pixel <x>,<y> to color number <col>
  // returns 0 on success, -1 on error
  OSD_GetPixel,   // (x0,y0)
  // returns color number of pixel <x>,<y>,  or -1
  OSD_SetRow,     // (x0,y0,x1,data)
  // fills pixels x0,y through  x1,y with the content of data[]
  // returns 0 on success, -1 on clipping all pixel (no pixel drawn)
  OSD_SetBlock,   // (x0,y0,x1,y1,increment{color},data)
  // fills pixels x0,y0 through  x1,y1 with the content of data[]
  // inc contains the width of one line in the data block,
  // inc<=0 uses blockwidth as linewidth
  // returns 0 on success, -1 on clipping all pixel
  OSD_FillRow,    // (x0,y0,x1,color)
  // fills pixels x0,y through  x1,y with the color <col>
  // returns 0 on success, -1 on clipping all pixel
  OSD_FillBlock,  // (x0,y0,x1,y1,color)
  // fills pixels x0,y0 through  x1,y1 with the color <col>
  // returns 0 on success, -1 on clipping all pixel
  OSD_Line,       // (x0,y0,x1,y1,color)
  // draw a line from x0,y0 to x1,y1 with the color <col>
  // returns 0 on success
  OSD_Query,      // (x0,y0,x1,y1,xasp{color}}), yasp=11
  // fills parameters with the picture dimensions and the pixel aspect ratio
  // returns 0 on success
  OSD_Test,       // ()
  // draws a test picture. for debugging purposes only
  // returns 0 on success
// TODO: remove "test" in final version
  OSD_Text,       // (x0,y0,size,color,text)
  OSD_SetWindow, //  (x0) set window with number 0<x0<8 as current
  OSD_MoveWindow, //  move current window to (x0, y0)  
} OSD_Command;

struct drawcmd {
        OSD_Command cmd;
        int x0;
        int y0;
        int x1;
        int y1;
        int color;
        void *data;
};

struct diseqc {
        int msglen;
        __u8 msg[10];
        int burst;
};


/* Hmmm, this is really Siemens card specific. It should become a private ioctl or
   something more general should be defined
*/


typedef struct VIDEOSTATE
{
	__u16	ProcessingState;		//0
	__u16	CommandID;
	__u16	dummy1;					//2
	__u16	dummy2;
	__u16	RateBuffFullness;		//4
	__u16	dummy3;
	__u16	BytesDecoded;			//6
	__u16	SkippedPictures;
	__u16	RepeatedPictures;		//8
	__u16	MostRecentPTS;
	__u16	LastPicture;			//10
	__u16	InitDone;
	__u16	FreezeIndex;			//12
	__u16	FindIndex;
	__u16	DistanceI;				//14
	__u16	ThresholdPTS;
	__u16	dummy4;					//16
	__u16	dummy5;
	__u16	DisablePTSFilt;			//18
	__u16	HSize;
	__u16	VSize;					//20
	__u16	AspectRatio;
	__u16	FrameRate;				//22
	__u16	BitRate;
	__u16	VBVBuffSize;			//24
	__u16	ConstParamFlag;
	__u16	IntraQ;					//26
	__u16	NonIntraQ;
	__u16	FrameInterval;			//28
	__u16	HeaderBackup;
	__u16	RedHeaderFlag;			//30
	__u16	SeqExtension;
	__u16	GOPTimeCode1;			//32
	__u16	GOPTimeCode2;
	__u16	ClosedGOP;				//34
	__u16	PICHeadTempRef;
	__u16	SegHeaderExt;			//36
	__u16	ColorDesc;
	__u16	ColorPrim;				//38
	__u16	TransferChar;
	__u16	MatrixCoeff;			//40
	__u16	DisplayHSize;
	__u16	DisplayVSize;			//42
	__u16	GOPHeader;
	__u16	TimeCodeW1;				//44
	__u16	TimeCodeW2;
} VIDEOSTATE, *PVIDEOSTATE;


#define VIDIOCGFRONTEND		_IOR('v',  BASE_VIDIOCPRIVATE+0, struct frontend)
#define VIDIOCSFRONTEND		_IOW('v',  BASE_VIDIOCPRIVATE+1, struct frontend)
#define VIDIOCSBITFILTER        _IOWR('v', BASE_VIDIOCPRIVATE+2, struct bitfilter)
#define VIDIOCSSHUTDOWNFILTER   _IOW('v',  BASE_VIDIOCPRIVATE+3, __u16)
#define VIDIOCSOSDCOMMAND       _IOW('v',  BASE_VIDIOCPRIVATE+4, struct drawcmd)
#define VIDIOCSDISEQCMSG        _IOW('v',  BASE_VIDIOCPRIVATE+5, struct diseqc)
#define VIDIOCGVIDEOSTATE       _IOR('v',  BASE_VIDIOCPRIVATE+6, VIDEOSTATE)

#define VIDIOCSASPECTRATIO      _IOW('v',  BASE_VIDIOCPRIVATE+7, int)
#define MONITOR_4_3 0
#define MONITOR_16_9 1

#define VIDIOCSPANSCAN          _IOW('v',  BASE_VIDIOCPRIVATE+8, int)
#define VID_NONE_PREF           0x00    / No aspect ration processing preferred 
#define VID_PAN_SCAN_PREF       0x01    // Pan and Scan Display preferred 
#define VID_VERT_COMP_PREF      0x02    // Vertical compression display preferred 
#define VID_VC_AND_PS_PREF      0x03    // Pan Scan and vertical Compression if allowed, 
#define VID_CENTRE_CUT_PREF     0x05    // Use pan-scan with zero vector

#endif

