#ifndef _DVB_H_
#define _DVB_H_


#ifdef __KERNEL__
#include "linux/socket.h" 
#include "linux/netdevice.h" 
#else
#include <netinet/in.h>
#endif

/* DEBI transfer mode defs */

#define DEBINOSWAP 0x4e0000
#define DEBISWAB   0x5e0000

#include "dvb_v4l.h"

#ifdef __KERNEL__


#define DVB_SET_FRONTEND        _IOW('v',  BASE_VIDIOCPRIVATE+0x10, struct frontend)
#define DVB_GET_FRONTEND        _IOR('v',  BASE_VIDIOCPRIVATE+0x11, struct frontend)
#define DVB_INIT_FRONTEND       _IOR('v',  BASE_VIDIOCPRIVATE+0x12, void)
#define DVB_RESET               _IOR('v',  BASE_VIDIOCPRIVATE+0x13, void)
#define DVB_WRITEREG            _IOR('v',  BASE_VIDIOCPRIVATE+0x14, void)


#if LINUX_VERSION_CODE < 0x020300
#define net_device device
#define DECLARE_MUTEX(foo)         struct semaphore foo = MUTEX
#define DECLARE_MUTEX_LOCKED(foo)  struct semaphore foo = MUTEX_LOCKED
#define WAIT_QUEUE                 struct wait_queue*
#define init_waitqueue_head(wq)    *(wq) = NULL;
#define DECLARE_WAITQUEUE(wait, current) struct wait_queue wait = { current, NULL }
#define set_current_state(state_value)			\
	do { current->state = state_value; } while (0)
#else
#define WAIT_QUEUE                 wait_queue_head_t
#endif



#define DATA_TELETEXT            0x00 
#define DATA_FSECTION            0x01
#define DATA_IPMPE               0x02
#define DATA_MPEG_RECORD         0x03
#define DATA_DEBUG_MESSAGE       0x04
#define DATA_COMMON_INTERFACE    0x05
#define DATA_MPEG_PLAY           0x06
#define DATA_BMP_LOAD            0x07
#define DATA_IRCOMMAND           0x08
#define DATA_PIPING              0x09
#define DATA_STREAMING           0x0a

#define CI_CMD_ERROR             0x00
#define CI_CMD_ACK               0x01
#define CI_CMD_SYSTEM_READY      0x02
#define CI_CMD_KEYPRESS          0x03
#define CI_CMD_ON_TUNED          0x04
#define CI_CMD_ON_SWITCH_PROGRAM 0x05
#define CI_CMD_SECTION_ARRIVED   0x06
#define CI_CMD_SECTION_TIMEOUT   0x07
#define	CI_CMD_TIME              0x08
#define	CI_CMD_ENTER_MENU        0x09
#define	CI_CMD_FAST_PSI          0x0a
#define	CI_CMD_GET_SLOT_INFO     0x0b

#define	CI_MSG_NONE              0x00
#define	CI_MSG_CI_INFO           0x01
#define	CI_MSG_MENU              0x02
#define	CI_MSG_LIST              0x03
#define	CI_MSG_TEXT              0x04
#define	CI_MSG_REQUEST_INPUT     0x05
#define	CI_MSG_INPUT_COMPLETE    0x06
#define	CI_MSG_LIST_MORE         0x07
#define	CI_MSG_MENU_MORE         0x08
#define	CI_MSG_CLOSE_MMI_IMM     0x09
#define	CI_MSG_SECTION_REQUEST   0x0a
#define	CI_MSG_CLOSE_FILTER      0x0b
#define	CI_PSI_COMPLETE          0x0c
#define	CI_MODULE_READY          0x0d
#define	CI_SWITCH_PRG_REPLY      0x0e
#define	CI_MSG_TEXT_MORE         0x0f

#define	CI_MSG_CA_PMT            0xe0
#define	CI_MSG_ERROR             0xf0


#ifdef V4L2
#define capture_device dvb_struct

/*  Per-open data for handling multiple opens on one device */
struct device_open
{
	int			isopen;
	int			noncapturing;
	struct capture_device	*dev;
};
#define MAX_OPENS	3
#endif


struct dvb_buf {
        int length;
        u8 *buf;
	spinlock_t lock;
	int head;
        int tail;
	WAIT_QUEUE queue;
};


/*
    AV_PES
 */		

#define AV_VIDEO 0x01
#define AV_AUDIO 0x02
#define AV_RES   0x55
	
#define PTS_FLAG      0x10
#define PRE_BYTE_MASK 0x03

#define MAX_AV  0x17f8
#define MAX_AVA 0x07f8

#define PROG_STREAM_MAP  0xBC
#define PRIVATE_STREAM1  0xBD
#define PADDING_STREAM   0xBE
#define PRIVATE_STREAM2  0xBF
#define AUDIO_STREAM_S   0xC0
#define AUDIO_STREAM_E   0xDF
#define VIDEO_STREAM_S   0xE0
#define VIDEO_STREAM_E   0xEF
#define ECM_STREAM       0xF0
#define EMM_STREAM       0xF1
#define DSM_CC_STREAM    0xF2
#define ISO13522_STREAM  0xF3
#define PROG_STREAM_DIR  0xFF

#define PTS_DTS_FLAGS    0xC0

//pts_dts flags 
#define PTS_ONLY         0x80
#define PTS_DTS          0xC0
	
typedef struct av_pes_packet_{
	u8 stream_id;
	u8 counter;
	u8 reserved;
	u8 flags;
	u8 llength[2];
	u8 pts[4];
	short  length;
	u8 gap;
	u8 payload[MAX_AV];
} av_pes_packet;

typedef struct p2astruct {
	int found;
	u8 cid;
	av_pes_packet apsv;
	av_pes_packet apsa;
	short plength;
	u8 plen[2];
	u8 flag1;
	u8 flag2;
	u8 hlength;
	u8 pts[5];
	int mpeg;
	int video_format;
	int hsize;
	int vsize;
	int aspect;
	int framerate;
	u8 check;
	int which;
	int nonblock;
	int what;
        u8 buf[MAX_AV+8];
	int done;
} p2a;




#define MAX_NUM_DVB 4
#define MCMAX 10
/* place to store all the neceassary device information */
struct dvb_struct {
#ifdef V4L2
        struct v4l2_device      v;
	char                    shortname[16];
	int                     is_registered;
	int                     open_count;
	struct device_open      open_data[MAX_OPENS];
	int                     capturing_opens;
#else
	struct video_device	video;
	struct video_device	vbi;
#endif
	int                     num;
	struct video_audio	audio;


	/* add-on devices */
	
	
	int dvbtype;
#define DVB_NONE 0
#define DVB_S    1
#define DVB_C    2
#define DVB_T    3
  
	/* buffers */
		
	void *iobuf;

        struct dvb_buf avin;
        struct dvb_buf avout;
        struct dvb_buf fsec;
#define AVINLEN (256*1024)
#define AVOUTLEN (256*1024)
#define SECBUFLEN (128*1024)

        void *bmpbuf;
        int bmpp;
        int bmplen;
        int bmp_win;
        u16 bmp_x, bmp_y;
        int bmp_trans;
        int bmp_state;
#define BMP_NONE     0
#define BMP_LOADING  1
#define BMP_LOADINGS 2
#define BMP_LOADED   3
	spinlock_t bmplock;
	WAIT_QUEUE bmpq;

        spinlock_t debilock;
	struct semaphore dcomlock;
	WAIT_QUEUE debiq;
	int debitype;
	int debilen;

	int recording;
	int playing;

	struct frontend front;
        struct net_device net;
        char netname[9];

        u16 filter_pid[34];
        u16 filter_flags[34];
  
        int osdwin;
        u16 osdbpp[8];
        int ci_slot[2];
#define CI_MODULE_PRESENT 1
#define CI_MODULE_OK      2
        int ci_stat;

        int playmode;
        int vidmode;
	p2a pesto;
	
};
#endif

#endif
