
/*
 * DVBLIB STRUCTURES
 *
 * Copyright (C) 1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as dent@cosy.sbg.ac.at, or
 * Thomas Mirlacher, Jakob-Haringerstr. 2, A-5020 Salzburg,
 * Austria
 *
 *------------------------------------------------------------
 *
 * $log$
 */


#ifndef __DVB_STRUCT_H__
#define __DVB_STRUCT_H__

#include <sys/types.h>

#define HILO(x) (x##_hi << 8 | x##_lo)


/********** Service Description **********/

typedef struct
	{
	char service_type;
	char *provider_name;
	char *service_name;
	} dvb_descr_service_t;

struct dvb_sdt_descr_struct;

typedef struct dvb_sdt_descr_struct
	{
	dvb_descr_service_t *service;
	char *country_avail;
	struct dvb_sdt_descr_struct *next;
	} dvb_sdt_descr_t;

struct dvb_sdt_service_struct;

typedef struct dvb_sdt_service_struct
	{
	u_int service_id;		// Service ID
	u_char free_ca_mode;
	dvb_sdt_descr_t *descr;
	struct dvb_sdt_service_struct *next;
	} dvb_sdt_service_t;

typedef struct
	{
	u_int version;
	u_int ts_id;			// Transport Stream ID
	u_int orig_nw_id;		// Original Network ID
	dvb_sdt_service_t *service;
	} dvb_sdt_t;


/********** NIT **********/

typedef struct 
	{
	u_int ts_id;			// Transport Stream ID
	u_int orig_nw_id;		// Original Network ID
	char *name;
	float freq;
	float orbit;
	u_char west_east;
	char polar[20];
	float rate;
	u_char fec;
	u_char qam;
	} dvb_nit_t;


/********** PMT **********/

struct dvb_pmt_stream_struct;

typedef struct dvb_pmt_stream_struct
	{
	u_char stream_type;
	u_int pid;
//	char *info;
	struct dvb_pmt_stream_struct *next;
	} dvb_pmt_stream_t;

struct dvb_pmt_struct;

typedef struct dvb_pmt_struct
	{
	u_int prog_nr;
	u_int version;
	u_int pcr_pid;
	u_int default_audio_pid;
	struct dvb_pmt_stream_struct *stream;
	} dvb_pmt_t;	


/********** PAT **********/

struct dvb_pat_prog_struct;

typedef struct dvb_pat_prog_struct
{
u_int prog_nr; // 0x00 -> prog = nit
u_int pid;

union
	{
	dvb_nit_t *nit;
	dvb_pmt_t *pmt;
	} prog;

struct dvb_pat_prog_struct *next;

} dvb_pat_prog_t;


typedef struct
	{
	u_int ts_id;
	char version;
	struct dvb_pat_prog_struct *prog;
	} dvb_pat_t;


/********** EIT **********/

struct dvb_eit_event_struct;

typedef struct dvb_eit_event_struct 
	{
	struct dvb_eit_event_struct *next;
	} dvb_eit_event_t;

typedef struct 
	{
	u_int ts_id;
	u_int orig_nw_id;
	dvb_eit_event_t *service;
	} dvb_eit_t;


#endif
