
/*
 *
 *
 * Copyright (C) 1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as dent@cosy.sbg.ac.at, or
 * Thomas Mirlacher, Jakob-Haringerstr. 2, A-5020 Salzburg,
 * Austria
 *
 *------------------------------------------------------------
 *
 * $log$
 */


#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#include "descr.h"
#include "dvb.h"

extern int debug_flag;


#if 0
int descr_network_name (char *buf, int len, void *_info)
{
	descr_gen_t *descr = (descr_gen_t *) buf;
	int i;
	char *info = malloc (descr->len);

	if (len < (descr->len + DESCR_GEN_LEN))
		return -1;

	memcpy (info, buf+2, descr->len);		
	info[descr->len] = '\0';

	_info = info;

	return descr->len + 2;
}

// 0x43
int descr_satellite_delivery_system (char *buf, int len, void *_info)
{
	descr_t *descr = (descr_t *) buf;

	if (len < (descr->len + 2))
		return -1;

	return descr->len + 2;	
}

#endif

// 0x48

dvb_descr_service_t *descr_service (char *buf, int len)
{
	char *ptr = buf;
	dvb_descr_service_t *service;

	if (get_descr_len(ptr) > len)
		return NULL;

	ptr += DESCR_GEN_LEN;

	service = calloc (1, sizeof (dvb_descr_service_t));

	service->service_type = *ptr;
	ptr ++;

	if (*ptr>0) {
	  service->provider_name = calloc (1, *ptr + 1);
	  memcpy (service->provider_name, ptr+1, *ptr);
	}
	ptr += *ptr + 1;
	if (*ptr>0) {
	  service->service_name = calloc (1, *ptr + 1);
	  memcpy (service->service_name, ptr+1, *ptr);
	}
	
	return service;	
}


// 0x49
char *descr_country_availability (char *buf, int len)
{
	char *country;
	char *ptr = buf;
	char avail;
	int i;

	if (get_descr_len(ptr) > len)
		return NULL;

	ptr += DESCR_GEN_LEN;

// 3 ... length of country code
	avail = *ptr & 0x01;		// country_availability_flag

	if (avail) {
		country = malloc (3 * (get_descr_len (buf) + 1) + 1);
		country[0] = '\0';
	} else {
		country = malloc (3 * (get_descr_len (buf) + 1) + 2);
		country[0] = '!';
		country[1] = '\0';
	}

	ptr += 1;

	for (i=1; i<=get_descr_len(buf)/3; i++) {
		snprintf (country, 3*i+1, "%s%c%c%c ", country, ptr[0], ptr[1], ptr[2]);
		ptr += 3;
	}

	return country;
}
