#include <sys/types.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include "../driver/dvb_v4l.h"

int OSDClose(int dev)
{
        struct drawcmd dc;

        dc.cmd=OSD_Close;
        return ioctl(dev, VIDIOCSOSDCOMMAND, &dc);
} 


int OSDOpen(int dev, int x0, int y0, int x1, int y1,
	     int BitPerPixel, int mix) 
{
        struct drawcmd dc;

        dc.cmd=OSD_Open;
	dc.x0=x0;
	dc.y0=y0;
	dc.x1=x1;
	dc.y1=y1;
	dc.color=BitPerPixel&0xf;
	return ioctl(dev, VIDIOCSOSDCOMMAND, &dc);
}

int OSDShow(int dev) 
{
        struct drawcmd dc;

        dc.cmd=OSD_Show;
	return ioctl(dev, VIDIOCSOSDCOMMAND, &dc);
}

int OSDHide(int dev) 
{
        struct drawcmd dc;

        dc.cmd=OSD_Hide;
	return ioctl(dev, VIDIOCSOSDCOMMAND, &dc);
}

int OSDClear(int dev) 
{
        struct drawcmd dc;

        dc.cmd=OSD_Clear;
	return ioctl(dev, VIDIOCSOSDCOMMAND, &dc);
}

int OSDFill(int dev, int color) 
{
        struct drawcmd dc;

        dc.cmd=OSD_Fill;
	dc.color=color;
	return ioctl(dev, VIDIOCSOSDCOMMAND, &dc);
}

int OSDSetColor(int dev, int color, int r, int g, int b, int op) 
{
        struct drawcmd dc;

        dc.cmd=OSD_SetColor;
	dc.color=color;
	dc.x0=r;
	dc.y0=g;
	dc.x1=b;
	dc.y1=op;
	return ioctl(dev, VIDIOCSOSDCOMMAND, &dc);
}

int OSDText(int dev, int x, int y, int size, int color, char *text) 
{
        struct drawcmd dc;
	
	dc.cmd=OSD_Text;
	dc.x0=x;
	dc.y0=y;
	dc.x1=size; // fontsize (1, 2 or 3)
	dc.data=text;
	dc.color=color;
	return ioctl(dev, VIDIOCSOSDCOMMAND, &dc);
}

int OSDSetPalette(int dev, int first, int last, unsigned char *data) 
{
        struct drawcmd dc;
	
	dc.cmd=OSD_SetPalette;
	dc.color=first;
	dc.x0=last;
	dc.data=data;
	return ioctl(dev, VIDIOCSOSDCOMMAND, &dc);
}

int OSDSetTrans(int dev, int trans)
{
        struct drawcmd dc;
	
	dc.cmd=OSD_SetTrans;
	dc.color=trans;
	return ioctl(dev, VIDIOCSOSDCOMMAND, &dc);
}

int OSDSetPixel(int dev, int x, int y, unsigned int color)
{
        struct drawcmd dc;
	
	dc.cmd=OSD_SetPixel;
	dc.x0=x;
	dc.y0=y;
	dc.color=color;
	return ioctl(dev, VIDIOCSOSDCOMMAND, &dc);
}

int OSDGetPixel(int dev, int x, int y)
{
        struct drawcmd dc;
	
	dc.cmd=OSD_GetPixel;
	dc.x0=x;
	dc.y0=y;
	return ioctl(dev, VIDIOCSOSDCOMMAND, &dc);
}

int OSDSetRow(int dev, int x, int y, int x1, unsigned char *data)
{
        struct drawcmd dc;
	
	dc.cmd=OSD_SetRow;
	dc.x0=x;
	dc.y0=y;
	dc.x1=x1;
	dc.data=data;
	return ioctl(dev, VIDIOCSOSDCOMMAND, &dc);
}

int OSDSetBlock(int dev, int x, int y, int x1, int y1, int inc, 
		unsigned char *data)
{
	int size;
        struct drawcmd dc;
	

	size=
	dc.cmd=OSD_SetBlock;
	dc.x0=x;
	dc.y0=y;
	dc.x1=x1;
	dc.y1=y1;
	dc.color=inc;
	dc.data=data;
	return ioctl(dev, VIDIOCSOSDCOMMAND, &dc);
}

int OSDFillRow(int dev, int x, int y, int x1, int color)
{
        struct drawcmd dc;
	
	dc.cmd=OSD_FillRow;
	dc.x0=x;
	dc.y0=y;
	dc.x1=x1;
	dc.color=color;
	return ioctl(dev, VIDIOCSOSDCOMMAND, &dc);
}

int OSDFillBlock(int dev, int x, int y, int x1, int y1, int color)
{
        struct drawcmd dc;
	
	dc.cmd=OSD_FillBlock;
	dc.x0=x;
	dc.y0=y;
	dc.x1=x1;
	dc.y1=y1;
	dc.color=color;
	return ioctl(dev, VIDIOCSOSDCOMMAND, &dc);
}

int OSDLine(int dev, int x, int y, int x1, int y1, int color)
{
        struct drawcmd dc;
	
	dc.cmd=OSD_Line;
	dc.x0=x;
	dc.y0=y;
	dc.x1=x1;
	dc.y1=y1;
	dc.color=color;
	return ioctl(dev, VIDIOCSOSDCOMMAND, &dc);
}

int OSDQuery(int dev)
{
        struct drawcmd dc;
	
	dc.cmd=OSD_Query;
	return ioctl(dev, VIDIOCSOSDCOMMAND, &dc);
}

int OSDSetWindow(int dev, int win)
{
        struct drawcmd dc;
	
	dc.cmd=OSD_SetWindow;
	dc.x0=win;
	return ioctl(dev, VIDIOCSOSDCOMMAND, &dc);
}

int OSDMoveWindow(int dev, int x, int y)
{
        struct drawcmd dc;
	
	dc.cmd=OSD_MoveWindow;
	dc.x0=x;
	dc.y0=y;
	return ioctl(dev, VIDIOCSOSDCOMMAND, &dc);
}

