(in-package :ucw-intro)

(defcomponent tal-component (template-component)
  ((page-name :initarg :page-name :accessor page-name)
   (contents :initarg :contents :accessor contents))
;;(:entry-point "^(|tal.ucw)$" (:application *ucw-intro-application* :class regexp-dispatcher))
  (:default-initargs :template-name "intro.tal" :page-name "Que tal!" :contents "<blink>Qual blink!!!</blink>"
                     :flag t))

(defcomponent more-tal (template-component)
  ((flag :initarg :flag :accessor flag)
   (da-var :initform "da-var from more-tal class" :accessor da-var)
   (tal-name :initform "more-wrapper.tal" :accessor tal-name)
   (another-var :initform "another-var from more-tal class" :accessor another-var)
   (a-href :initform "http://planet.lisp.org" :accessor a-href)
   (a-class :initform (make-instance 'in-list) :accessor a-class)
   (spliced-href :accessor spliced-href :initform '("http://" "planet." "lisp." "org"))
   (my-list :accessor my-list
            :initform `((,(make-instance 'in-list)
                         ,(make-instance 'another-in-list))
                        (((da-var . "da-var from a-list") (another-var . "another-var from a-list")))
                        (,(make-instance 'in-list :da-var "da-var from class in another bullet")
                         ((da-var . "da-var from another a-list") (another-var . "another-var from another alist")))
                        (,*tal-table*))))
;;(:entry-point "^(|more-tal.ucw)$" (:application *ucw-intro-application* :class regexp-dispatcher))
  (:default-initargs :template-name "more-tal.tal" :flag nil))

(defclass in-list ()
  ((da-var :initarg :da-var :initform "da-var from in-list class" :accessor da-var)))

(defclass another-in-list ()
  ((another-var :initform "another-var from in-list class" :accessor another-var)))

(defparameter *tal-table* (make-hash-table))

(setf (gethash 'another-var *tal-table*) "another-var from hash")
