(in-package :ucw-intro)

(defcomponent basics (simple-window-component)
  ((cow :initarg :cow :accessor cow :initform "aspacia")
   (pig :initarg :pig :accessor pig :initform "knorrie"))
  (:default-initargs :title "hi")
  (:render ()
           (with-slots (cow pig)
               basics
             (<:as-is "in the old days, to update the name of your lovely cow named <b>" #\Newline)
             (<:as-html cow)
             (<:as-is "</b> you would update it like so: ")
             (<:form :action "get.ucw"
                     :method "GET"
                     (<:text :name "cow")
                     (<:submit :value "name your cow"))
             (<:p (<:a :href "get.ucw" "go to get without any value to get to the default value of the entry point"))
             (<:p
              (<:as-html "but we have left them behind. In the brave new world we will update the name of our lovely pig like: ")
              (<ucw:form :method "GET"
                         :action (refresh-component basics)
                         (<ucw:text :accessor pig)
                         (<:submit :value "name your pig")))
             (<:p
              (<:as-html "to pass a value and control to another component we do like so:")
              (let ((stuff-to-say ""))
                (<ucw:form :action (get-stuff-to-say basics stuff-to-say)
                           :method "POST"
                           (<ucw:textarea :accessor stuff-to-say)
                           (<:br)
                           (<:submit :value "have something to say"))))
             (<:p (<ucw:a :action (jump 'office) "jump to office")))))


;;(defentry-point "get.ucw"
;;    (:application *ucw-intro-application*)
;;    ((cow "moo"))
;;  (+ 2 2)
;;  (let ((cow (concatenate 'string "mighty " cow)))
;;    (call 'basics :cow cow)))

(defaction get-stuff-to-say ((basics basics) stuff-to-say)
  (let ((stuff-to-say (concatenate 'string stuff-to-say " (boring!!!)")))
    (setf (cow basics) (call 'the-other-one :stuff-to-say stuff-to-say))))

(defaction ok ((c component) &optional (value c))
  (answer value))

(defcomponent the-other-one (simple-window-component)
  ((stuff-to-say :initarg :stuff-to-say :accessor stuff-to-say))
  (:default-initargs :title "hi"
    :content-type "text/html; charset=utf-8;")
  (:render ()
           (<:p
            (<:as-html "- "(stuff-to-say the-other-one)))
           (<:p
            (<:as-html "yeah, very 'enlightning'. Dazzle me some more: "))
           (<ucw:form :method "GET"
                      :action (refresh-component the-other-one)
                      (<ucw:textarea :reader (stuff-to-say the-other-one)
                                     :writer #'(lambda (x)(setf (stuff-to-say the-other-one) (concatenate 'string x " (boring !!!!!)"))))
                      (<:br)
                      (<:submit :value "have something to say"))
           (<:br)
           (<ucw:a :action (ok the-other-one "nice to be back") "back to the last component")))

(defcomponent timeline (widget-component)
  ((history :initarg :history :accessor history))
  (:render () (<:as-html (history timeline))))

(defcomponent drawer (widget-component)
  ((contents :initarg :contents :accessor contents))
  (:render () (<:as-html (contents drawer))))

(defcomponent office (simple-window-component)
  ((what-happened :initform '(0 0 0) :accessor what-happened)
   (closet :component (switching-container
                       :current-component-key 'in-office
                       :contents
                       `((in-office       . ,(make-instance 'timeline :history "You stand alone in the office of your evil boss. In front of you you see a closet in which you are sure you will find valuables with which you can pay off your insurmountable debts."))
                         (top-drawer    . ,(make-instance 'drawer
                                                          :contents "you find memoirs of a broken soul"))
                         (middle-drawer . ,(make-instance 'drawer
                                                          :contents "you find an agenda of grinding daily chores"))
                         (bottom-drawer . ,(make-instance 'drawer
                                                          :contents "you find an ointment to take the edge off"))))
           :accessor closet))
  (:render ()
           (with-slots (what-happened closet)
               office
             (unless (find-component closet 'leave) 
               (case (container.current-component-key closet)
                 ('top-drawer (setf (car what-happened) 1))
                 ('bottom-drawer (setf (cadr what-happened) 1))
                 ('middle-drawer (setf (caddr what-happened) 1)))
               (when (and (= (car what-happened) 1)
                          (= (cadr what-happened) 1)
                          (= (caddr what-happened) 1))
                 (add-component closet
                                (make-instance 'timeline :history "You leave the office ashamed and angry. You know now your evil boss is also a human being and you will have to feel compassion for him forever.")
                                'leave)))
             (render closet)
             (<:br)
             (<:as-html "What will you do next?")
             (<:br)
             (unless (eql (container.current-component-key closet) 'leave)
               (flet ((drawer-link (name text)
                        (<ucw:a :action (switch-component (closet office) name)
                                (<:as-html text))))
                 (<:ul
                  (<:li (drawer-link 'top-drawer "inspect top drawer"))
                  (<:li (drawer-link 'middle-drawer "inspect middle drawer"))
                  (<:li (drawer-link 'bottom-drawer "inspect bottom drawer"))
                  (<:li (drawer-link 'in-office "recall what your doing here"))
                  (when (find-component closet 'leave)
                    (<:li (drawer-link 'leave "leave"))))))
             (<:br)
             (<ucw:a :action (jump 'basics) "go back to where you came from"))))
