/*
 * Decompiled with CFR 0.152.
 */
package com.paragent.observer;

import com.paragent.observer.Base64;
import com.paragent.observer.DisconnectException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class ParagentSocket
extends Socket {
    private String computer;
    private String company;
    private String certificate;
    private String password;
    private int nPort;
    private String sHost;
    protected Socket sock;
    protected SSLSocket sslSock;
    private static final String ALGORITHM = "sunx509";
    private static final String PASSWORD = "observer";

    public ParagentSocket(String sHost, int nPort, String computer, String company, String password) throws DisconnectException {
        this.sHost = sHost;
        this.nPort = nPort;
        this.computer = computer;
        this.company = company;
        this.password = password;
        System.out.println("connecting...");
        if (!this.connectSocket()) {
            throw new DisconnectException("Couldn't connect to " + sHost + ":" + nPort);
        }
        System.out.println("connected");
        if (!this.doParagentHandshake()) {
            throw new DisconnectException("Failed to perform handshake with reflector");
        }
        System.out.println("handshook");
        if (!this.connectSSL()) {
            throw new DisconnectException("SSL handshake failed");
        }
        System.out.println("SSL connected");
        if (!this.sendPassword()) {
            throw new DisconnectException("Password not accepted");
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.sslSock.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.sslSock.getOutputStream();
    }

    public void close() {
        try {
            if (this.sslSock != null && !this.sslSock.isClosed()) {
                this.sslSock.close();
            }
            if (!this.sock.isClosed()) {
                this.sock.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean connectSocket() {
        try {
            this.sock = new Socket(this.sHost, this.nPort);
            this.sock.setSoTimeout(10000);
        }
        catch (UnknownHostException ex) {
            return false;
        }
        catch (IOException ex) {
            return false;
        }
        return this.sock.isConnected();
    }

    private boolean connectSSL() {
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new Base64.InputStream(new ByteArrayInputStream("/u3+7QAAAAIAAAABAAAAAQAMc2VjdXJlY2xpZW50AAABEJOOlcQAAAK7MIICtzAO BgorBgEEASoCEQEBBQAEggKj+Z/QvVBn9F+Dez3z/GndEyP1SKR5o9bC2duXy2nB J66pYoCqk6XsZ5phhJ5LWbduPU+KKOcfjHM1QyhebkAkWHMlKDusY0DFXrDm4LXN rtvINIJpBgj8sId5K9VmZymrJFJ2Kts+tXKpLmnIl6CBzex9g1cdfQV+sUZemGTb bP7zXy7ISAVrxhdmB4fjI9c0OuJ+ggocJu82bZdkUR+RWd0ER8VspCoAFCftHqxI chtQBAY0fQ5sh3jMIvDXrn4cbA/gh3jjhIjTFXESAmI2Kc1mxF9NBrPs93BF3PFS ZKKPJl3Q5HNpH2ezN4D1O+2QdV/9ggxjhH5+hfpQz+YA/9Hii1qf9KJ5/h8GmTdS mQemSzP5NaQXXS72OxGWQ9RPo/ioqtIDx4rCHmG8PuZf2VvxRGPa4YCENjx/Ubg/ GLqdn7tUgGsEipN38WeXfiqItde2mUJ0GlDXTtG8UwgqokCuJV1bSK4g25pGV20P Me4wYZarKbg7iLbLkO5t+p5DDDE3OZYQ8v2U+DXQfWzhMJaKNtWKPFgh9AWSLDg1 9InaNOWRKWer+7MAXn9GUdg75fa4LVtJD6rtuQ2214uQIazWPcdIsl531lZZgw2H O9cT5PvtiN5ydiBTiItxU/+/dadXphB0RsOSKuLyhEhTAxjfX2VbejZKgS3WKCM6 afaZ2CebGDj8+iO+DGRogh94ajVnfA7g/6x6V7ke7pViYafOSGQT9iCx+YxtHFKC 4LXYB6zrsltUEpWGFgGzgUJCF6X4OWNLJqvczJRADTQCAMla4nzQx1lTeEScphdK hhMVQCbAJs7gsHp/0m72lk8erMtkMOCe4CtlQ0XU5jdGtZaZOAY88pGtIqyOUWTA DaaJmpGhjdoHU399e7dMDKYpWl97AAAAAQAFWC41MDkAAAJEMIICQDCCAakCBEXH kQQwDQYJKoZIhvcNAQEEBQAwZzELMAkGA1UEBhMCdXMxEDAOBgNVBAgTB1Vua25v d24xEDAOBgNVBAcTB1Vua25vd24xEDAOBgNVBAoTB1Vua25vd24xEDAOBgNVBAsT B1Vua25vd24xEDAOBgNVBAMTB1Vua25vd24wHhcNMDcwMjA1MjAxODEyWhcNMDcw NTA2MjAxODEyWjBnMQswCQYDVQQGEwJ1czEQMA4GA1UECBMHVW5rbm93bjEQMA4G A1UEBxMHVW5rbm93bjEQMA4GA1UEChMHVW5rbm93bjEQMA4GA1UECxMHVW5rbm93 bjEQMA4GA1UEAxMHVW5rbm93bjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA pf6nRcLoGHxtn87qE7absvamcOrPejQ1j0GvR4LTFJOhd8QhiD8ehbET/cJYDItr T2vPbofg9LNuOOJ93j5qprvnYePaOXIzZQBroq7YvXLsBqTt5yEVGuw4az1JM8Kf H9I6wgI6XA9fKZs9gqG3SDGHRxZyX/sTvuAjAlbnlf0CAwEAATANBgkqhkiG9w0B AQQFAAOBgQA6wbeMkDCr3kgC5UIzXZ9Vs56fuhKbvVJrZ682oN61/7fYpZzYQ4aN H5yPIM98oQnWpZ1u2OwZPcwCARWrziN4DKPe9nl/VtgGKMrEcWsFuHxIce3sx1/b I4tG+/drqZQUjQOOKJeS3NdhG/KKBdUAvBqh3Y9dKjdfT4ID285I4+pH+bmBLzdU 1nq7el6LeiyeIiuP ".getBytes())), PASSWORD.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(ALGORITHM);
            kmf.init(ks, PASSWORD.toCharArray());
            KeyManager[] km = kmf.getKeyManagers();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(ALGORITHM);
            tmf.init(ks);
            TrustManager[] tm = tmf.getTrustManagers();
            SSLContext sslc = SSLContext.getInstance("TLS");
            sslc.init(km, tm, null);
            SSLSocketFactory ssf = sslc.getSocketFactory();
            this.sslSock = (SSLSocket)ssf.createSocket(this.sock, this.sHost, this.nPort, true);
            this.sslSock.setNeedClientAuth(false);
            this.sslSock.setUseClientMode(false);
            this.sslSock.startHandshake();
            return !this.sslSock.isClosed();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (UnrecoverableKeyException e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean sendPassword() {
        try {
            System.out.println("*" + this.password);
            this.sslSock.getOutputStream().write((String.valueOf(this.password) + "\n").getBytes());
            return !this.sslSock.isClosed();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private String readLine() throws IOException, DisconnectException {
        int cAvailable = 0;
        DataInputStream is = new DataInputStream(new BufferedInputStream(this.sock.getInputStream(), 16384));
        while (this.sock.isConnected() && (cAvailable = is.available()) == 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.sock.isConnected()) {
            throw new DisconnectException("Disconnected in ReadLine()");
        }
        byte[] rgb = new byte[cAvailable];
        int i = 0;
        while (i < cAvailable) {
            try {
                byte b;
                rgb[i] = b = is.readByte();
                byte[] rgbNewlineTest = new byte[]{b};
                String sNewlineTest = new String(rgbNewlineTest);
                if (sNewlineTest.equals("\n")) {
                }
            }
            catch (SocketTimeoutException e) {}
            break;
            ++i;
        }
        return new String(rgb);
    }

    private void writeLine(String sData) throws IOException {
        if (!sData.endsWith("\r\n")) {
            sData = String.valueOf(sData) + "\r\n";
        }
        OutputStream os = this.sock.getOutputStream();
        os.write(sData.getBytes());
    }

    protected boolean doParagentHandshake() throws DisconnectException {
        try {
            this.writeLine("(\"OBSERVER\" \"" + this.computer + "\" \"" + this.company + "\")");
            String response = this.readLine();
            System.out.println("<--" + response);
            return response.startsWith("(GOOD)");
        }
        catch (IOException e) {
            return false;
        }
    }
}

