/*
 * Decompiled with CFR 0.152.
 */
package com.paragent.observer;

public class DH {
    private long gen;
    private long mod;
    private long priv;
    private long pub;
    private long key;
    private long maxNum = Integer.MAX_VALUE;
    private static final int DH_MAX_BITS = 31;
    private static final int DH_RANGE = 100;
    private static final int DH_MOD = 1;
    private static final int DH_GEN = 2;
    private static final int DH_PRIV = 3;
    private static final int DH_PUB = 4;
    private static final int DH_KEY = 5;

    public DH() {
    }

    public DH(long generator, long modulus) throws Exception {
        if (generator >= this.maxNum || modulus >= this.maxNum) {
            throw new Exception("Modulus or generator too large.");
        }
        this.gen = generator;
        this.mod = modulus;
    }

    private long rng(long limit) {
        return (long)(Math.random() * (double)limit);
    }

    private boolean millerRabin(long n, int trials) {
        long a = 0L;
        int i = 0;
        while (i < trials) {
            a = this.rng(n - 3L) + 2L;
            if (this.XpowYmodN(a, n - 1L, n) != 1L) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private long generatePrime() {
        long start;
        long prime = 0L;
        while ((prime = this.tryToGeneratePrime(start = this.rng(this.maxNum))) == 0L) {
        }
        return prime;
    }

    private long tryToGeneratePrime(long prime) {
        if ((prime & 1L) == 0L) {
            ++prime;
        }
        long cnt = 0L;
        while (!this.millerRabin(prime, 25) && cnt++ < 100L && prime < this.maxNum) {
            if ((prime += 2L) % 3L != 0L) continue;
            prime += 2L;
        }
        return cnt >= 100L || prime >= this.maxNum ? 0L : prime;
    }

    private long XpowYmodN(long x, long y, long N) {
        long result = 1L;
        long oneShift63 = Long.MIN_VALUE;
        int i = 0;
        while (i < 64) {
            result = result * result % N;
            if ((y & Long.MIN_VALUE) != 0L) {
                result = result * x % N;
            }
            y <<= 1;
            ++i;
        }
        return result;
    }

    public void createKeys() {
        this.gen = this.generatePrime();
        this.mod = this.generatePrime();
        if (this.gen > this.mod) {
            long swap = this.gen;
            this.gen = this.mod;
            this.mod = swap;
        }
    }

    public long createInterKey() {
        this.priv = this.rng(this.maxNum);
        this.pub = this.XpowYmodN(this.gen, this.priv, this.mod);
        return this.pub;
    }

    public long createEncryptionKey(long interKey) throws Exception {
        if (interKey >= this.maxNum) {
            throw new Exception("interKey too large");
        }
        this.key = this.XpowYmodN(interKey, this.priv, this.mod);
        return this.key;
    }

    public long getValue(int flags) {
        switch (flags) {
            case 1: {
                return this.mod;
            }
            case 2: {
                return this.gen;
            }
            case 3: {
                return this.priv;
            }
            case 4: {
                return this.pub;
            }
            case 5: {
                return this.key;
            }
        }
        return 0L;
    }

    public int bits(long number) {
        int i = 0;
        while (i < 64) {
            if ((number /= 2L) < 2L) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static byte[] longToBytes(long number) {
        byte[] bytes = new byte[8];
        int i = 0;
        while (i < 8) {
            bytes[i] = (byte)(0xFFL & number >> 8 * (7 - i));
            ++i;
        }
        return bytes;
    }

    public static long bytesToLong(byte[] bytes) {
        long result = 0L;
        int i = 0;
        while (i < 8) {
            result <<= 8;
            result += (long)bytes[i];
            ++i;
        }
        return result;
    }
}

